/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonObject;
import java.io.File;
import java.util.Date;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.mp.api.WxMpKefuService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.kefu.WxMpKefuMessage;
import me.chanjar.weixin.mp.bean.kefu.request.WxMpKfAccountRequest;
import me.chanjar.weixin.mp.bean.kefu.request.WxMpKfSessionRequest;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfList;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfMsgList;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfOnlineList;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfSessionGetResult;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfSessionList;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfSessionWaitCaseList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpKefuServiceImpl
implements WxMpKefuService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private WxMpService wxMpService;

    public WxMpKefuServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public boolean sendKefuMessage(WxMpKefuMessage message) throws WxErrorException {
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/cgi-bin/message/custom/send", message.toJson());
        return responseContent != null;
    }

    @Override
    public WxMpKfList kfList() throws WxErrorException {
        String responseContent = this.wxMpService.get("https://api.weixin.qq.com/cgi-bin/customservice/getkflist", null);
        return WxMpKfList.fromJson(responseContent);
    }

    @Override
    public WxMpKfOnlineList kfOnlineList() throws WxErrorException {
        String responseContent = this.wxMpService.get("https://api.weixin.qq.com/cgi-bin/customservice/getonlinekflist", null);
        return WxMpKfOnlineList.fromJson(responseContent);
    }

    @Override
    public boolean kfAccountAdd(WxMpKfAccountRequest request) throws WxErrorException {
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/customservice/kfaccount/add", request.toJson());
        return responseContent != null;
    }

    @Override
    public boolean kfAccountUpdate(WxMpKfAccountRequest request) throws WxErrorException {
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/customservice/kfaccount/update", request.toJson());
        return responseContent != null;
    }

    @Override
    public boolean kfAccountInviteWorker(WxMpKfAccountRequest request) throws WxErrorException {
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/customservice/kfaccount/inviteworker", request.toJson());
        return responseContent != null;
    }

    @Override
    public boolean kfAccountUploadHeadImg(String kfAccount, File imgFile) throws WxErrorException {
        WxMediaUploadResult responseContent = (WxMediaUploadResult)this.wxMpService.execute(MediaUploadRequestExecutor.create((RequestHttp)this.wxMpService.getRequestHttp()), String.format("https://api.weixin.qq.com/customservice/kfaccount/uploadheadimg?kf_account=%s", kfAccount), imgFile);
        return responseContent != null;
    }

    @Override
    public boolean kfAccountDel(String kfAccount) throws WxErrorException {
        String responseContent = this.wxMpService.get(String.format("https://api.weixin.qq.com/customservice/kfaccount/del?kf_account=%s", kfAccount), null);
        return responseContent != null;
    }

    @Override
    public boolean kfSessionCreate(String openid, String kfAccount) throws WxErrorException {
        WxMpKfSessionRequest request = new WxMpKfSessionRequest(kfAccount, openid);
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/customservice/kfsession/create", request.toJson());
        return responseContent != null;
    }

    @Override
    public boolean kfSessionClose(String openid, String kfAccount) throws WxErrorException {
        WxMpKfSessionRequest request = new WxMpKfSessionRequest(kfAccount, openid);
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/customservice/kfsession/close", request.toJson());
        return responseContent != null;
    }

    @Override
    public WxMpKfSessionGetResult kfSessionGet(String openid) throws WxErrorException {
        String responseContent = this.wxMpService.get(String.format("https://api.weixin.qq.com/customservice/kfsession/getsession?openid=%s", openid), null);
        return WxMpKfSessionGetResult.fromJson(responseContent);
    }

    @Override
    public WxMpKfSessionList kfSessionList(String kfAccount) throws WxErrorException {
        String responseContent = this.wxMpService.get(String.format("https://api.weixin.qq.com/customservice/kfsession/getsessionlist?kf_account=%s", kfAccount), null);
        return WxMpKfSessionList.fromJson(responseContent);
    }

    @Override
    public WxMpKfSessionWaitCaseList kfSessionGetWaitCase() throws WxErrorException {
        String responseContent = this.wxMpService.get("https://api.weixin.qq.com/customservice/kfsession/getwaitcase", null);
        return WxMpKfSessionWaitCaseList.fromJson(responseContent);
    }

    @Override
    public WxMpKfMsgList kfMsgList(Date startTime, Date endTime, Long msgId, Integer number) throws WxErrorException {
        if (number > 10000) {
            throw new WxErrorException(WxError.builder().errorCode(-1).errorMsg("\u975e\u6cd5\u53c2\u6570\u8bf7\u6c42\uff0c\u6bcf\u6b21\u6700\u591a\u67e5\u8be210000\u6761\u8bb0\u5f55\uff01").build());
        }
        if (startTime.after(endTime)) {
            throw new WxErrorException(WxError.builder().errorCode(-1).errorMsg("\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01").build());
        }
        JsonObject param = new JsonObject();
        param.addProperty("starttime", (Number)(startTime.getTime() / 1000L));
        param.addProperty("endtime", (Number)(endTime.getTime() / 1000L));
        param.addProperty("msgid", (Number)msgId);
        param.addProperty("number", (Number)number);
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/customservice/msgrecord/getmsglist", param.toString());
        return WxMpKfMsgList.fromJson(responseContent);
    }

    @Override
    public WxMpKfMsgList kfMsgList(Date startTime, Date endTime) throws WxErrorException {
        int number = 10000;
        WxMpKfMsgList result = this.kfMsgList(startTime, endTime, 1L, number);
        if (result != null && result.getNumber() == number) {
            Long msgId = result.getMsgId();
            WxMpKfMsgList followingResult = this.kfMsgList(startTime, endTime, msgId, number);
            while (followingResult != null && followingResult.getRecords().size() > 0) {
                result.getRecords().addAll(followingResult.getRecords());
                result.setNumber(result.getNumber() + followingResult.getNumber());
                result.setMsgId(followingResult.getMsgId());
                followingResult = this.kfMsgList(startTime, endTime, followingResult.getMsgId(), number);
            }
        }
        return result;
    }
}

