/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.BeanUtils;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpStoreService;
import me.chanjar.weixin.mp.bean.store.WxMpStoreBaseInfo;
import me.chanjar.weixin.mp.bean.store.WxMpStoreInfo;
import me.chanjar.weixin.mp.bean.store.WxMpStoreListResult;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;

public class WxMpStoreServiceImpl
implements WxMpStoreService {
    private WxMpService wxMpService;

    public WxMpStoreServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public void add(WxMpStoreBaseInfo request) throws WxErrorException {
        BeanUtils.checkRequiredFields((Object)request);
        String response = this.wxMpService.post("https://api.weixin.qq.com/cgi-bin/poi/addpoi", request.toJson());
        WxError wxError = WxError.fromJson((String)response);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
    }

    @Override
    public WxMpStoreBaseInfo get(String poiId) throws WxErrorException {
        JsonObject paramObject = new JsonObject();
        paramObject.addProperty("poi_id", poiId);
        String response = this.wxMpService.post("https://api.weixin.qq.com/cgi-bin/poi/getpoi", paramObject.toString());
        WxError wxError = WxError.fromJson((String)response);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
        return WxMpStoreBaseInfo.fromJson(new JsonParser().parse(response).getAsJsonObject().get("business").getAsJsonObject().get("base_info").toString());
    }

    @Override
    public void delete(String poiId) throws WxErrorException {
        JsonObject paramObject = new JsonObject();
        paramObject.addProperty("poi_id", poiId);
        String response = this.wxMpService.post("https://api.weixin.qq.com/cgi-bin/poi/delpoi", paramObject.toString());
        WxError wxError = WxError.fromJson((String)response);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
    }

    @Override
    public WxMpStoreListResult list(int begin, int limit) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("begin", (Number)begin);
        params.addProperty("limit", (Number)limit);
        String response = this.wxMpService.post("https://api.weixin.qq.com/cgi-bin/poi/getpoilist", params.toString());
        WxError wxError = WxError.fromJson((String)response);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
        return WxMpStoreListResult.fromJson(response);
    }

    @Override
    public List<WxMpStoreInfo> listAll() throws WxErrorException {
        int limit = 50;
        WxMpStoreListResult list = this.list(0, limit);
        List<WxMpStoreInfo> stores = list.getBusinessList();
        if (list.getTotalCount() > limit) {
            int begin = limit;
            WxMpStoreListResult followingList = this.list(begin, limit);
            while (followingList.getBusinessList().size() > 0) {
                stores.addAll(followingList.getBusinessList());
                if ((begin += limit) >= list.getTotalCount()) break;
                followingList = this.list(begin, limit);
            }
        }
        return stores;
    }

    @Override
    public void update(WxMpStoreBaseInfo request) throws WxErrorException {
        String response = this.wxMpService.post("https://api.weixin.qq.com/cgi-bin/poi/updatepoi", request.toJson());
        WxError wxError = WxError.fromJson((String)response);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
    }

    @Override
    public List<String> listCategories() throws WxErrorException {
        String response = this.wxMpService.get("https://api.weixin.qq.com/cgi-bin/poi/getwxcategory", null);
        WxError wxError = WxError.fromJson((String)response);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
        return (List)WxMpGsonBuilder.create().fromJson(new JsonParser().parse(response).getAsJsonObject().get("category_list"), new TypeToken<List<String>>(){}.getType());
    }
}

