package me.chanjar.weixin.mp.bean.pay;

import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 *  发送红包请求参数对象
 *  Created by Binary Wang on 2016/9/24.
 * @author binarywang (https://github.com/binarywang)
 */
@XStreamAlias("xml")
public class WxSendRedpackRequest {
  /**
  * mch_billno
  * 商户订单号（每个订单号必须唯一）  组成：mch_id+yyyymmdd+10位一天内不能重复的数字。  接口根据商户订单号支持重入，如出现超时可再调用。
  */
  @XStreamAlias("mch_billno")
  private String mchBillno;

  /**
   * send_name
   * 商户名称 
   * 红包发送者名称
   */
  @XStreamAlias("send_name")
  private String sendName;

  /**
   *  re_openid
   *  接受红包的用户   用户在wxappid下的openid
   */
  @XStreamAlias("re_openid")
  private String reOpenid;

  /**
   *  total_amount
   *  红包总额
   */
  @XStreamAlias("total_amount")
  private Integer totalAmount;

  /**
   *  total_num
   *  红包发放总人数
   */
  @XStreamAlias("total_num")
  private Integer totalNum;

  /**
   *  amt_type
   *  红包金额设置方式
   *  ALL_RAND—全部随机,商户指定总金额和红包发放总人数，由微信支付随机计算出各红包金额
   *  裂变红包必填
   */
  @XStreamAlias("amt_type")
  private String amtType;

  /**
   *  wishing
   *  红包祝福语
   */
  @XStreamAlias("wishing")
  private String wishing;

  /**
   *  client_ip
   *  服务器Ip地址
   *  调用接口的机器Ip地址
   */
  @XStreamAlias("client_ip")
  private String clientIp;

  /**
   *  act_name
   *  活动名称
   */
  @XStreamAlias("act_name")
  private String actName;

  /**
   *  remark
   *  备注
   */
  @XStreamAlias("remark")
  private String remark;

  /**
   * wxappid
   * 微信分配的公众账号ID（企业号corpid即为此appId）。接口传入的所有appid应该为公众号的appid（在mp.weixin.qq.com申请的），不能为APP的appid（在open.weixin.qq.com申请的）
   */
  @XStreamAlias("wxappid")
  private String wxAppid;

  /**
   * mch_id
   * 微信支付分配的商户号
   */
  @XStreamAlias("mch_id")
  private String mchId;

  /**
   * nonce_str
   * 随机字符串，不长于32位
   */
  @XStreamAlias("nonce_str")
  private String nonceStr;

  /**
   * sign
   * 详见<a href="https://pay.weixin.qq.com/wiki/doc/api/tools/cash_coupon.php?chapter=4_3">签名生成算法</a>
   */
  @XStreamAlias("sign")
  private String sign;

  /**
   * <pre>
   * scene_id
   * 场景id
   * PRODUCT_1:商品促销
   * PRODUCT_2:抽奖
   * PRODUCT_3:虚拟物品兑奖 
   * PRODUCT_4:企业内部福利
   * PRODUCT_5:渠道分润
   * PRODUCT_6:保险回馈
   * PRODUCT_7:彩票派奖
   * PRODUCT_8:税务刮奖
   * 非必填字段
   * </pre>
   */
  @XStreamAlias("scene_id")
  private String sceneId;

  /**
   * <pre>
   * risk_info
   * 活动信息
   * posttime:用户操作的时间戳
   * mobile:业务系统账号的手机号，国家代码-手机号。不需要+号
   * deviceid :mac 地址或者设备唯一标识 
   * clientversion :用户操作的客户端版本
   * 把值为非空的信息用key=value进行拼接，再进行urlencode
   * urlencode(posttime=xx&mobile=xx&deviceid=xx)
   *  非必填字段
   * </pre>
   */
  @XStreamAlias("risk_info")
  private String riskInfo;

  /**
   * <pre>
   * consume_mch_id
   * 资金授权商户号
   * 资金授权商户号
   * 服务商替特约商户发放时使用  
   * 非必填字段
   * </pre>
   */
  @XStreamAlias("consume_mch_id")
  private String consumeMchId;

  public String getMchBillno() {
    return this.mchBillno;
  }

  public void setMchBillno(String mchBillno) {
    this.mchBillno = mchBillno;
  }

  public String getSendName() {
    return this.sendName;
  }

  public void setSendName(String sendName) {
    this.sendName = sendName;
  }

  public String getReOpenid() {
    return this.reOpenid;
  }

  public void setReOpenid(String reOpenid) {
    this.reOpenid = reOpenid;
  }

  public Integer getTotalAmount() {
    return this.totalAmount;
  }

  public void setTotalAmount(Integer totalAmount) {
    this.totalAmount = totalAmount;
  }

  public Integer getTotalNum() {
    return this.totalNum;
  }

  public void setTotalNum(Integer totalNum) {
    this.totalNum = totalNum;
  }

  public String getAmtType() {
    return this.amtType;
  }

  public void setAmtType(String amtType) {
    this.amtType = amtType;
  }

  public String getWishing() {
    return this.wishing;
  }

  public void setWishing(String wishing) {
    this.wishing = wishing;
  }

  public String getClientIp() {
    return this.clientIp;
  }

  public void setClientIp(String clientIp) {
    this.clientIp = clientIp;
  }

  public String getActName() {
    return this.actName;
  }

  public void setActName(String actName) {
    this.actName = actName;
  }

  public String getRemark() {
    return this.remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public String getWxAppid() {
    return this.wxAppid;
  }

  public void setWxAppid(String wxAppid) {
    this.wxAppid = wxAppid;
  }

  public String getMchId() {
    return this.mchId;
  }

  public void setMchId(String mchId) {
    this.mchId = mchId;
  }

  public String getNonceStr() {
    return this.nonceStr;
  }

  public void setNonceStr(String nonceStr) {
    this.nonceStr = nonceStr;
  }

  public String getSign() {
    return this.sign;
  }

  public void setSign(String sign) {
    this.sign = sign;
  }

  public String getSceneId() {
    return this.sceneId;
  }

  public void setSceneId(String sceneId) {
    this.sceneId = sceneId;
  }

  public String getRiskInfo() {
    return this.riskInfo;
  }

  public void setRiskInfo(String riskInfo) {
    this.riskInfo = riskInfo;
  }

  public String getConsumeMchId() {
    return this.consumeMchId;
  }

  public void setConsumeMchId(String consumeMchId) {
    this.consumeMchId = consumeMchId;
  }

}
