/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaCloudService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudBatchDeleteFileResult;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudBatchDownloadFileResult;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudCloudDatabaseMigrateQueryInfoResult;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudDatabaseCollectionGetResult;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudDatabaseCreateIndexRequest;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudDatabaseQueryResult;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudDatabaseUpdateResult;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudGetQcloudTokenResult;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudSendSmsV2Result;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudUploadFileResult;
import cn.binarywang.wx.miniapp.bean.cloud.request.WxCloudSendSmsV2Request;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaCloudServiceImpl
implements WxMaCloudService {
    private static final Logger log = LoggerFactory.getLogger(WxMaCloudServiceImpl.class);
    private static final Joiner blankJoiner = Joiner.on((String)"").skipNulls();
    private final WxMaService wxMaService;

    @Override
    public String invokeCloudFunction(String name, String body) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        return this.invokeCloudFunction(cloudEnv, name, body);
    }

    @Override
    public String invokeCloudFunction(String env, String name, String body) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        String response = this.wxMaService.post(String.format("https://api.weixin.qq.com/tcb/invokecloudfunction?env=%s&name=%s", cloudEnv, name), body);
        return GsonParser.parse((String)response).get("resp_data").getAsString();
    }

    @Override
    public List<String> add(String collection, List list) throws WxErrorException {
        String jsonData = WxMaGsonBuilder.create().toJson((Object)list);
        String query = blankJoiner.join((Object)"db.collection('", (Object)collection, new Object[]{"')", ".add({data: ", jsonData, "})"});
        JsonObject params = new JsonObject();
        params.addProperty("env", this.wxMaService.getWxMaConfig().getCloudEnv());
        params.addProperty("query", query);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/tcb/databaseadd", params.toString());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent));
        }
        JsonArray idArray = jsonObject.getAsJsonArray("id_list");
        ArrayList<String> idList = new ArrayList<String>();
        for (JsonElement id : idArray) {
            idList.add(id.getAsString());
        }
        return idList;
    }

    @Override
    public String add(String collection, Object obj) throws WxErrorException {
        String jsonData = WxMaGsonBuilder.create().toJson(obj);
        String query = blankJoiner.join((Object)"db.collection('", (Object)collection, new Object[]{"')", ".add({data: ", jsonData, "})"});
        JsonObject params = new JsonObject();
        params.addProperty("env", this.wxMaService.getWxMaConfig().getCloudEnv());
        params.addProperty("query", query);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/tcb/databaseadd", params.toString());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent));
        }
        JsonArray idArray = jsonObject.getAsJsonArray("id_list");
        return idArray.getAsString();
    }

    @Override
    public JsonArray databaseAdd(String query) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        return this.databaseAdd(cloudEnv, query);
    }

    @Override
    public JsonArray databaseAdd(String env, String query) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databaseadd", ImmutableMap.of((Object)"env", (Object)env, (Object)"query", (Object)query));
        return GsonParser.parse((String)response).get("id_list").getAsJsonArray();
    }

    @Override
    public Integer delete(String collection, String whereJson) throws WxErrorException {
        String query = blankJoiner.join((Object)"db.collection('", (Object)collection, new Object[]{"')", ".where(", whereJson, ").remove()"});
        JsonObject params = new JsonObject();
        params.addProperty("env", this.wxMaService.getWxMaConfig().getCloudEnv());
        params.addProperty("query", query);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasedelete", params.toString());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent));
        }
        return jsonObject.get("deleted").getAsInt();
    }

    @Override
    public int databaseDelete(String query) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        return this.databaseDelete(cloudEnv, query);
    }

    @Override
    public int databaseDelete(String env, String query) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasedelete", ImmutableMap.of((Object)"env", (Object)env, (Object)"query", (Object)query));
        return GsonParser.parse((String)response).get("deleted").getAsInt();
    }

    @Override
    public WxCloudDatabaseUpdateResult update(String collection, String whereJson, String updateJson) throws WxErrorException {
        String query = blankJoiner.join((Object)"db.collection('", (Object)collection, new Object[]{"')", ".where(", whereJson, ").update({data:", updateJson, " })"});
        JsonObject params = new JsonObject();
        params.addProperty("env", this.wxMaService.getWxMaConfig().getCloudEnv());
        params.addProperty("query", query);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/tcb/databaseupdate", params.toString());
        return (WxCloudDatabaseUpdateResult)WxGsonBuilder.create().fromJson(responseContent, WxCloudDatabaseUpdateResult.class);
    }

    @Override
    public WxCloudDatabaseUpdateResult databaseUpdate(String query) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        return this.databaseUpdate(cloudEnv, query);
    }

    @Override
    public WxCloudDatabaseUpdateResult databaseUpdate(String env, String query) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databaseupdate", ImmutableMap.of((Object)"env", (Object)env, (Object)"query", (Object)query));
        return (WxCloudDatabaseUpdateResult)WxGsonBuilder.create().fromJson(response, WxCloudDatabaseUpdateResult.class);
    }

    @Override
    public WxCloudDatabaseQueryResult query(String collection, String whereJson, Map<String, String> orderBy, Integer skip, Integer limit) throws WxErrorException {
        if (StringUtils.isBlank((CharSequence)whereJson)) {
            whereJson = "{}";
        }
        StringBuilder orderBySb = new StringBuilder();
        if (null != orderBy && !orderBy.isEmpty()) {
            for (Map.Entry<String, String> entry : orderBy.entrySet()) {
                orderBySb.append(".orderBy('").append(entry.getKey()).append("', '").append(entry.getValue()).append("')");
            }
        }
        if (null == limit) {
            limit = 100;
        }
        if (null == skip) {
            skip = 0;
        }
        String query = blankJoiner.join((Object)"db.collection('", (Object)collection, new Object[]{"')", ".where(", whereJson, ")", orderBySb.toString(), ".skip(", skip, ").limit(", limit, ").get()"});
        JsonObject params = new JsonObject();
        params.addProperty("env", this.wxMaService.getWxMaConfig().getCloudEnv());
        params.addProperty("query", query);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasequery", params.toString());
        return (WxCloudDatabaseQueryResult)WxGsonBuilder.create().fromJson(responseContent, WxCloudDatabaseQueryResult.class);
    }

    @Override
    public WxCloudDatabaseQueryResult databaseQuery(String query) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        return this.databaseQuery(cloudEnv, query);
    }

    @Override
    public WxCloudDatabaseQueryResult databaseQuery(String env, String query) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasequery", ImmutableMap.of((Object)"env", (Object)env, (Object)"query", (Object)query));
        return (WxCloudDatabaseQueryResult)WxGsonBuilder.create().fromJson(response, WxCloudDatabaseQueryResult.class);
    }

    @Override
    public JsonArray databaseAggregate(String query) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        return this.databaseAggregate(cloudEnv, query);
    }

    @Override
    public JsonArray databaseAggregate(String env, String query) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databaseaggregate", ImmutableMap.of((Object)"env", (Object)env, (Object)"query", (Object)query));
        return GsonParser.parse((String)response).get("data").getAsJsonArray();
    }

    @Override
    public Long count(String collection, String whereJson) throws WxErrorException {
        String query = blankJoiner.join((Object)"db.collection('", (Object)collection, new Object[]{"')", ".where(", whereJson, ").count()"});
        JsonObject params = new JsonObject();
        params.addProperty("env", this.wxMaService.getWxMaConfig().getCloudEnv());
        params.addProperty("query", query);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasecount", params.toString());
        return GsonParser.parse((String)responseContent).get("count").getAsLong();
    }

    @Override
    public Long databaseCount(String query) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        return this.databaseCount(cloudEnv, query);
    }

    @Override
    public Long databaseCount(String env, String query) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasecount", ImmutableMap.of((Object)"env", (Object)env, (Object)"query", (Object)query));
        return GsonParser.parse((String)response).get("count").getAsLong();
    }

    @Override
    public void updateIndex(String collectionName, List<WxCloudDatabaseCreateIndexRequest> createIndexes, List<String> dropIndexNames) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        this.updateIndex(cloudEnv, collectionName, createIndexes, dropIndexNames);
    }

    @Override
    public void updateIndex(String env, String collectionName, List<WxCloudDatabaseCreateIndexRequest> createIndexes, List<String> dropIndexNames) throws WxErrorException {
        ArrayList dropIndexes = Lists.newArrayList();
        if (dropIndexNames != null) {
            for (String index : dropIndexNames) {
                dropIndexes.add(ImmutableMap.of((Object)"name", (Object)index));
            }
        }
        this.wxMaService.post("https://api.weixin.qq.com/tcb/updateindex", ImmutableMap.of((Object)"env", (Object)env, (Object)"collection_name", (Object)collectionName, (Object)"create_indexes", createIndexes, (Object)"drop_indexes", (Object)dropIndexes));
    }

    @Override
    public Long databaseMigrateImport(String collectionName, String filePath, int fileType, boolean stopOnError, int conflictMode) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        return this.databaseMigrateImport(cloudEnv, collectionName, filePath, fileType, stopOnError, conflictMode);
    }

    @Override
    public Long databaseMigrateImport(String env, String collectionName, String filePath, int fileType, boolean stopOnError, int conflictMode) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("env", env);
        params.addProperty("collection_name", collectionName);
        params.addProperty("file_path", filePath);
        params.addProperty("file_type", (Number)fileType);
        params.addProperty("stop_on_error", Boolean.valueOf(stopOnError));
        params.addProperty("conflict_mode", (Number)conflictMode);
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasemigrateimport", params.toString());
        return GsonParser.parse((String)response).get("job_id").getAsLong();
    }

    @Override
    public Long databaseMigrateExport(String filePath, int fileType, String query) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        return this.databaseMigrateExport(cloudEnv, filePath, fileType, query);
    }

    @Override
    public Long databaseMigrateExport(String env, String filePath, int fileType, String query) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("env", env);
        params.addProperty("file_path", filePath);
        params.addProperty("file_type", (Number)fileType);
        params.addProperty("query", query);
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasemigrateexport", params.toString());
        return GsonParser.parse((String)response).get("job_id").getAsLong();
    }

    @Override
    public WxCloudCloudDatabaseMigrateQueryInfoResult databaseMigrateQueryInfo(Long jobId) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        return this.databaseMigrateQueryInfo(cloudEnv, jobId);
    }

    @Override
    public WxCloudCloudDatabaseMigrateQueryInfoResult databaseMigrateQueryInfo(String env, Long jobId) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasemigratequeryinfo", ImmutableMap.of((Object)"env", (Object)env, (Object)"job_id", (Object)jobId));
        return (WxCloudCloudDatabaseMigrateQueryInfoResult)WxGsonBuilder.create().fromJson(response, WxCloudCloudDatabaseMigrateQueryInfoResult.class);
    }

    @Override
    public WxCloudUploadFileResult uploadFile(String path) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        return this.uploadFile(cloudEnv, path);
    }

    @Override
    public WxCloudUploadFileResult uploadFile(String env, String path) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/uploadfile", ImmutableMap.of((Object)"env", (Object)env, (Object)"path", (Object)path));
        return (WxCloudUploadFileResult)WxGsonBuilder.create().fromJson(response, WxCloudUploadFileResult.class);
    }

    @Override
    public WxCloudBatchDownloadFileResult batchDownloadFile(String[] fileIds, long[] maxAges) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        return this.batchDownloadFile(cloudEnv, fileIds, maxAges);
    }

    @Override
    public WxCloudBatchDownloadFileResult batchDownloadFile(String env, String[] fileIds, long[] maxAges) throws WxErrorException {
        ArrayList fileList = Lists.newArrayList();
        int i = 0;
        for (String fileId : fileIds) {
            fileList.add(ImmutableMap.of((Object)"fileid", (Object)fileId, (Object)"max_age", (Object)maxAges[i++]));
        }
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/batchdownloadfile", ImmutableMap.of((Object)"env", (Object)env, (Object)"file_list", (Object)fileList));
        return (WxCloudBatchDownloadFileResult)WxGsonBuilder.create().fromJson(response, WxCloudBatchDownloadFileResult.class);
    }

    @Override
    public WxCloudBatchDeleteFileResult batchDeleteFile(String[] fileIds) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        return this.batchDeleteFile(cloudEnv, fileIds);
    }

    @Override
    public WxCloudBatchDeleteFileResult batchDeleteFile(String env, String[] fileIds) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/batchdeletefile", ImmutableMap.of((Object)"env", (Object)env, (Object)"fileid_list", (Object)fileIds));
        return (WxCloudBatchDeleteFileResult)WxGsonBuilder.create().fromJson(response, WxCloudBatchDeleteFileResult.class);
    }

    @Override
    public WxCloudGetQcloudTokenResult getQcloudToken(long lifeSpan) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/getqcloudtoken", ImmutableMap.of((Object)"lifespan", (Object)lifeSpan));
        return (WxCloudGetQcloudTokenResult)WxGsonBuilder.create().fromJson(response, WxCloudGetQcloudTokenResult.class);
    }

    @Override
    public void databaseCollectionAdd(String collectionName) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        this.databaseCollectionAdd(cloudEnv, collectionName);
    }

    @Override
    public void databaseCollectionAdd(String env, String collectionName) throws WxErrorException {
        this.wxMaService.post("https://api.weixin.qq.com/tcb/databasecollectionadd", ImmutableMap.of((Object)"env", (Object)env, (Object)"collection_name", (Object)collectionName));
    }

    @Override
    public void databaseCollectionDelete(String collectionName) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        this.databaseCollectionDelete(cloudEnv, collectionName);
    }

    @Override
    public void databaseCollectionDelete(String env, String collectionName) throws WxErrorException {
        this.wxMaService.post("https://api.weixin.qq.com/tcb/databasecollectiondelete", ImmutableMap.of((Object)"env", (Object)env, (Object)"collection_name", (Object)collectionName));
    }

    @Override
    public WxCloudDatabaseCollectionGetResult databaseCollectionGet(Long limit, Long offset) throws WxErrorException {
        String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
        return this.databaseCollectionGet(cloudEnv, limit, offset);
    }

    @Override
    public WxCloudDatabaseCollectionGetResult databaseCollectionGet(String env, Long limit, Long offset) throws WxErrorException {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("env", env);
        if (limit != null) {
            params.put("limit", limit);
        }
        if (offset != null) {
            params.put("offset", offset);
        }
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasecollectionget", params);
        return (WxCloudDatabaseCollectionGetResult)WxGsonBuilder.create().fromJson(response, WxCloudDatabaseCollectionGetResult.class);
    }

    @Override
    public WxCloudSendSmsV2Result sendSmsV2(WxCloudSendSmsV2Request request) throws WxErrorException {
        if (request.getEnv() == null) {
            String cloudEnv = this.wxMaService.getWxMaConfig().getCloudEnv();
            request.setEnv(cloudEnv);
        }
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/sendsmsv2", request);
        return (WxCloudSendSmsV2Result)WxGsonBuilder.create().fromJson(response, WxCloudSendSmsV2Result.class);
    }

    public WxMaCloudServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

