/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.api;

import java.util.concurrent.TimeUnit;
import me.chanjar.weixin.common.api.WxMessageDuplicateChecker;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMessageInRedisDuplicateChecker
implements WxMessageDuplicateChecker {
    private int expire = 10;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RedissonClient redissonClient;

    @Override
    public boolean isDuplicate(String messageId) {
        RBucket r = this.redissonClient.getBucket("wx:message:duplicate:check:" + messageId);
        boolean setSuccess = r.trySet((Object)"1", (long)this.expire, TimeUnit.SECONDS);
        return !setSuccess;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public WxMessageInRedisDuplicateChecker(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

