/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.locks;

import com.github.jedis.lock.JedisLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.Pool;

public class JedisDistributedLock
implements Lock {
    private final Pool<Jedis> jedisPool;
    private final JedisLock lock;

    public JedisDistributedLock(Pool<Jedis> jedisPool, String key) {
        this.jedisPool = jedisPool;
        this.lock = new JedisLock(key);
    }

    @Override
    public void lock() {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            if (!this.lock.acquire(jedis)) {
                throw new RuntimeException("acquire timeouted");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("lock failed", e);
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            if (!this.lock.acquire(jedis)) {
                throw new RuntimeException("acquire timeouted");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean tryLock() {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            boolean bl = this.lock.acquire(jedis);
            return bl;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("lock failed", e);
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            boolean bl = this.lock.acquire(jedis);
            return bl;
        }
    }

    @Override
    public void unlock() {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            this.lock.release(jedis);
        }
    }

    @Override
    public Condition newCondition() {
        throw new RuntimeException("unsupported method");
    }
}

