/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.impl;

import com.binance.api.client.BinanceApiCallback;
import com.binance.api.client.exception.BinanceApiException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class BinanceApiWebSocketListener<T>
extends WebSocketListener {
    private BinanceApiCallback<T> callback;
    private Class<T> eventClass;

    public BinanceApiWebSocketListener(BinanceApiCallback<T> callback, Class<T> eventClass) {
        this.callback = callback;
        this.eventClass = eventClass;
    }

    public void onMessage(WebSocket webSocket, String text) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Object event = mapper.readValue(text, this.eventClass);
            this.callback.onResponse(event);
        }
        catch (IOException e) {
            throw new BinanceApiException(e);
        }
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        throw new BinanceApiException(t);
    }
}

