/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.domain.general;

import com.binance.api.client.domain.general.RateLimit;
import com.binance.api.client.domain.general.SymbolInfo;
import com.binance.api.client.exception.BinanceApiException;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExchangeInfo {
    private String timezone;
    private Long serverTime;
    private List<RateLimit> rateLimits;
    private List<SymbolInfo> symbols;

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public Long getServerTime() {
        return this.serverTime;
    }

    public void setServerTime(Long serverTime) {
        this.serverTime = serverTime;
    }

    public List<RateLimit> getRateLimits() {
        return this.rateLimits;
    }

    public void setRateLimits(List<RateLimit> rateLimits) {
        this.rateLimits = rateLimits;
    }

    public List<SymbolInfo> getSymbols() {
        return this.symbols;
    }

    public void setSymbols(List<SymbolInfo> symbols) {
        this.symbols = symbols;
    }

    public SymbolInfo getSymbolInfo(String symbol) {
        return this.symbols.stream().filter(symbolInfo -> symbolInfo.getSymbol().equals(symbol)).findFirst().orElseThrow(() -> new BinanceApiException("Unable to obtain information for symbol " + symbol));
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("timezone", (Object)this.timezone).append("serverTime", (Object)this.serverTime).append("rateLimits", this.rateLimits).append("symbols", this.symbols).toString();
    }
}

