/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.domain.event;

import com.binance.api.client.domain.event.AccountUpdateEvent;
import com.binance.api.client.domain.event.OrderTradeUpdateEvent;
import com.binance.api.client.domain.event.UserDataUpdateEvent;
import com.binance.api.client.exception.BinanceApiException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class UserDataUpdateEventDeserializer
extends JsonDeserializer<UserDataUpdateEvent> {
    public UserDataUpdateEvent deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        ObjectCodec oc = jp.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jp);
        String json = node.toString();
        String eventTypeId = node.get("e").asText();
        Long eventTime = node.get("E").asLong();
        UserDataUpdateEvent.UserDataUpdateEventType userDataUpdateEventType = UserDataUpdateEvent.UserDataUpdateEventType.fromEventTypeId(eventTypeId);
        UserDataUpdateEvent userDataUpdateEvent = new UserDataUpdateEvent();
        userDataUpdateEvent.setEventType(userDataUpdateEventType);
        userDataUpdateEvent.setEventTime(eventTime);
        if (userDataUpdateEventType == UserDataUpdateEvent.UserDataUpdateEventType.ACCOUNT_UPDATE) {
            AccountUpdateEvent accountUpdateEvent = this.getUserDataUpdateEventDetail(json, AccountUpdateEvent.class);
            userDataUpdateEvent.setAccountUpdateEvent(accountUpdateEvent);
        } else {
            OrderTradeUpdateEvent orderTradeUpdateEvent = this.getUserDataUpdateEventDetail(json, OrderTradeUpdateEvent.class);
            userDataUpdateEvent.setOrderTradeUpdateEvent(orderTradeUpdateEvent);
        }
        return userDataUpdateEvent;
    }

    public <T> T getUserDataUpdateEventDetail(String json, Class<T> clazz) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new BinanceApiException(e);
        }
    }
}

