/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.impl;

import com.binance.api.client.BinanceApiCallback;
import com.binance.api.client.BinanceApiWebSocketClient;
import com.binance.api.client.config.BinanceApiConfig;
import com.binance.api.client.domain.event.AggTradeEvent;
import com.binance.api.client.domain.event.AllMarketTickersEvent;
import com.binance.api.client.domain.event.CandlestickEvent;
import com.binance.api.client.domain.event.DepthEvent;
import com.binance.api.client.domain.event.UserDataUpdateEvent;
import com.binance.api.client.domain.market.CandlestickInterval;
import com.binance.api.client.impl.BinanceApiWebSocketListener;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;

public class BinanceApiWebSocketClientImpl
implements BinanceApiWebSocketClient,
Closeable {
    private final OkHttpClient client;

    public BinanceApiWebSocketClientImpl(OkHttpClient client) {
        this.client = client;
    }

    @Override
    public Closeable onDepthEvent(String symbols, BinanceApiCallback<DepthEvent> callback) {
        String channel = Arrays.stream(symbols.split(",")).map(String::trim).map(s -> String.format("%s@depth", s)).collect(Collectors.joining("/"));
        return this.createNewWebSocket(channel, new BinanceApiWebSocketListener<DepthEvent>(callback, DepthEvent.class));
    }

    @Override
    public Closeable onCandlestickEvent(String symbols, CandlestickInterval interval, BinanceApiCallback<CandlestickEvent> callback) {
        String channel = Arrays.stream(symbols.split(",")).map(String::trim).map(s -> String.format("%s@kline_%s", s, interval.getIntervalId())).collect(Collectors.joining("/"));
        return this.createNewWebSocket(channel, new BinanceApiWebSocketListener<CandlestickEvent>(callback, CandlestickEvent.class));
    }

    @Override
    public Closeable onAggTradeEvent(String symbols, BinanceApiCallback<AggTradeEvent> callback) {
        String channel = Arrays.stream(symbols.split(",")).map(String::trim).map(s -> String.format("%s@aggTrade", s)).collect(Collectors.joining("/"));
        return this.createNewWebSocket(channel, new BinanceApiWebSocketListener<AggTradeEvent>(callback, AggTradeEvent.class));
    }

    @Override
    public Closeable onUserDataUpdateEvent(String listenKey, BinanceApiCallback<UserDataUpdateEvent> callback) {
        return this.createNewWebSocket(listenKey, new BinanceApiWebSocketListener<UserDataUpdateEvent>(callback, UserDataUpdateEvent.class));
    }

    @Override
    public Closeable onAllMarketTickersEvent(BinanceApiCallback<List<AllMarketTickersEvent>> callback) {
        String channel = "!ticker@arr";
        return this.createNewWebSocket("!ticker@arr", new BinanceApiWebSocketListener<List<AllMarketTickersEvent>>(callback, new TypeReference<List<AllMarketTickersEvent>>(){}));
    }

    @Override
    public void close() {
    }

    private Closeable createNewWebSocket(String channel, BinanceApiWebSocketListener<?> listener) {
        String streamingUrl = String.format("%s/%s", BinanceApiConfig.getStreamApiBaseUrl(), channel);
        Request request = new Request.Builder().url(streamingUrl).build();
        WebSocket webSocket = this.client.newWebSocket(request, listener);
        return () -> {
            int code = 1000;
            listener.onClosing(webSocket, 1000, null);
            webSocket.close(1000, null);
            listener.onClosed(webSocket, 1000, null);
        };
    }
}

