/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.uibasics.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.util.AttributeSet;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.bijoysingh.uibasics.R;
import com.github.bijoysingh.uibasics.base.CustomLinearLayout;
import com.github.bijoysingh.uibasics.setters.ImageSetter;
import com.github.bijoysingh.uibasics.setters.TextSetter;

public abstract class UITextViewBase
extends CustomLinearLayout
implements ImageSetter,
TextSetter {
    protected ImageView mIcon;
    protected TextView mLabel;

    public UITextViewBase(Context context) {
        super(context);
    }

    public UITextViewBase(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public UITextViewBase(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public UITextViewBase(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public void init() {
        this.setContentLayout(R.layout.fig_textview);
        this.mIcon = (ImageView)this.findViewById(R.id.icon);
        this.mLabel = (TextView)this.findViewById(R.id.label);
    }

    @Override
    public void setImageResource(@DrawableRes Integer imageResource) {
        this.mIcon.setImageResource(imageResource.intValue());
        this.mIcon.setVisibility(0);
    }

    @Override
    public void setImageDrawable(Drawable imageDrawable) {
        this.mIcon.setImageDrawable(imageDrawable);
        this.mIcon.setVisibility(0);
    }

    @Override
    public void setImageBitmap(Bitmap bitmap) {
        this.mIcon.setImageBitmap(bitmap);
        this.mIcon.setVisibility(0);
    }

    @Override
    public void setImagePadding(int padding) {
        this.mIcon.setPadding(padding, padding, padding, padding);
    }

    @Override
    public void setImageTint(int color) {
        this.mIcon.setColorFilter(color);
    }

    @Override
    public void setImageSize(int size) {
        this.mIcon.getLayoutParams().height = size;
        this.mIcon.getLayoutParams().width = size;
        this.requestLayout();
    }

    @Override
    public void setText(@StringRes Integer stringResource) {
        this.mLabel.setText(stringResource.intValue());
    }

    @Override
    public void setText(String text) {
        this.mLabel.setText((CharSequence)text);
    }

    @Override
    public void setTextColor(int color) {
        this.mLabel.setTextColor(color);
    }

    @Override
    public void setTextSize(float size) {
        this.mLabel.setTextSize(size);
    }

    @Override
    public void setTextPadding(int padding) {
        this.mLabel.setPadding(padding, padding, padding, padding);
    }

    @Override
    public void setTextAllCaps(boolean textAllCaps) {
        this.mLabel.setAllCaps(textAllCaps);
    }

    @Override
    public void setTextMaxLines(int maxLines) {
        this.mLabel.setMaxLines(maxLines);
    }

    public ImageView getIcon() {
        return this.mIcon;
    }

    public TextView getLabel() {
        return this.mLabel;
    }
}

