/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.uibasics.attributes;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.TextView;
import com.github.bijoysingh.uibasics.R;

public class TextAttributes {
    private Context context;
    private AttributeSet attributeSet;
    private int[] attrStyleable;
    private int textStyleable;
    private int textSizeStyleable;
    private int textWidthStyleable;
    private int textColorStyleable;
    private int textStyleStyleable;
    private int textPaddingStyleable;
    private int textMarginStyleable;
    private int textMarginStartStyleable;
    private int textMarginEndStyleable;
    private int textMarginTopStyleable;
    private int textMarginBottomStyleable;
    private int textMaxLinesStyleable;
    private int textAllCapsStyleable;

    public TextAttributes(Builder builder) {
        this.context = builder.context;
        this.attributeSet = builder.attributeSet;
        this.attrStyleable = builder.attrStyleable;
        this.textStyleable = builder.textStyleable;
        this.textColorStyleable = builder.textColorStyleable;
        this.textSizeStyleable = builder.textSizeStyleable;
        this.textWidthStyleable = builder.textWidthStyleable;
        this.textStyleStyleable = builder.textStyleStyleable;
        this.textPaddingStyleable = builder.textPaddingStyleable;
        this.textMarginStyleable = builder.textMarginStyleable;
        this.textMarginStartStyleable = builder.textMarginStartStyleable;
        this.textMarginEndStyleable = builder.textMarginEndStyleable;
        this.textMarginTopStyleable = builder.textMarginTopStyleable;
        this.textMarginBottomStyleable = builder.textMarginBottomStyleable;
        this.textMaxLinesStyleable = builder.textMaxLinesStyleable;
        this.textAllCapsStyleable = builder.textAllCapsStyleable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(TextView view) {
        TypedArray typedArray = this.context.getTheme().obtainStyledAttributes(this.attributeSet, this.attrStyleable, 0, 0);
        try {
            int count;
            if (this.textStyleable != -1) {
                view.setText(typedArray.getText(this.textStyleable));
            }
            if (this.textStyleStyleable != -1) {
                if (Build.VERSION.SDK_INT < 23) {
                    view.setTextAppearance(this.context, typedArray.getResourceId(this.textStyleStyleable, 0));
                } else {
                    view.setTextAppearance(typedArray.getResourceId(this.textStyleStyleable, 0));
                }
            }
            if (this.textSizeStyleable != -1) {
                view.setTextSize(0, typedArray.getDimension(this.textSizeStyleable, this.context.getResources().getDimension(R.dimen.default_text_size)));
            }
            if (this.textWidthStyleable != -1) {
                view.getLayoutParams().width = (int)typedArray.getDimension(this.textWidthStyleable, this.context.getResources().getDimension(R.dimen.default_text_width));
            }
            if (this.textColorStyleable != -1) {
                view.setTextColor(typedArray.getColor(this.textColorStyleable, -16777216));
            }
            if (this.textPaddingStyleable != -1) {
                int padding = (int)typedArray.getDimension(this.textPaddingStyleable, 0.0f);
                view.setPadding(padding, padding, padding, padding);
            }
            int margin = this.textMarginStyleable != -1 ? (int)typedArray.getDimension(this.textMarginStyleable, 0.0f) : 0;
            int marginStart = this.textMarginStartStyleable != -1 ? (int)typedArray.getDimension(this.textMarginStartStyleable, 0.0f) : margin;
            int marginEnd = this.textMarginEndStyleable != -1 ? (int)typedArray.getDimension(this.textMarginEndStyleable, 0.0f) : margin;
            int marginTop = this.textMarginTopStyleable != -1 ? (int)typedArray.getDimension(this.textMarginTopStyleable, 0.0f) : margin;
            int marginBottom = this.textMarginBottomStyleable != -1 ? (int)typedArray.getDimension(this.textMarginBottomStyleable, 0.0f) : margin;
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            params.setMargins(marginStart, marginTop, marginEnd, marginBottom);
            if (this.textMaxLinesStyleable != -1 && (count = typedArray.getInteger(this.textMaxLinesStyleable, -1)) >= 0) {
                view.setMaxLines(count);
            }
            if (this.textAllCapsStyleable != -1) {
                boolean allCaps = typedArray.getBoolean(this.textAllCapsStyleable, false);
                view.setAllCaps(allCaps);
            }
        }
        finally {
            typedArray.recycle();
        }
    }

    public static class Builder {
        private Context context;
        private AttributeSet attributeSet;
        private int[] attrStyleable;
        private int textWidthStyleable = -1;
        private int textStyleable = -1;
        private int textSizeStyleable = -1;
        private int textColorStyleable = -1;
        private int textStyleStyleable = -1;
        private int textPaddingStyleable = -1;
        private int textMarginStyleable = -1;
        private int textMarginStartStyleable = -1;
        private int textMarginEndStyleable = -1;
        private int textMarginTopStyleable = -1;
        private int textMarginBottomStyleable = -1;
        private int textMaxLinesStyleable = -1;
        private int textAllCapsStyleable = -1;

        public Builder setContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder setAttributeSet(AttributeSet attributeSet) {
            this.attributeSet = attributeSet;
            return this;
        }

        public Builder setAttrStyleable(int[] attrStyleable) {
            this.attrStyleable = attrStyleable;
            return this;
        }

        public Builder setTextStyleable(int textStyleable) {
            this.textStyleable = textStyleable;
            return this;
        }

        public Builder setTextSizeStyleable(int textSizeStyleable) {
            this.textSizeStyleable = textSizeStyleable;
            return this;
        }

        public Builder setTextWidthStyleable(int textWidthStyleable) {
            this.textWidthStyleable = textWidthStyleable;
            return this;
        }

        public Builder setTextColorStyleable(int textColorStyleable) {
            this.textColorStyleable = textColorStyleable;
            return this;
        }

        public Builder setTextStyleStyleable(int textStyleStyleable) {
            this.textStyleStyleable = textStyleStyleable;
            return this;
        }

        public Builder setTextPaddingStyleable(int textPaddingStyleable) {
            this.textPaddingStyleable = textPaddingStyleable;
            return this;
        }

        public Builder setTextMarginStyleable(int textMarginStyleable) {
            this.textMarginStyleable = textMarginStyleable;
            return this;
        }

        public Builder setTextMarginBottomStyleable(int textMarginBottomStyleable) {
            this.textMarginBottomStyleable = textMarginBottomStyleable;
            return this;
        }

        public Builder setTextMarginTopStyleable(int textMarginTopStyleable) {
            this.textMarginTopStyleable = textMarginTopStyleable;
            return this;
        }

        public Builder setTextMarginEndStyleable(int textMarginEndStyleable) {
            this.textMarginEndStyleable = textMarginEndStyleable;
            return this;
        }

        public Builder setTextMarginStartStyleable(int textMarginStartStyleable) {
            this.textMarginStartStyleable = textMarginStartStyleable;
            return this;
        }

        public Builder setTextMaxLinesStyleable(int textMaxLinesStyleable) {
            this.textMaxLinesStyleable = textMaxLinesStyleable;
            return this;
        }

        public Builder setTextAllCapsStyleable(int textAllCapsStyleable) {
            this.textAllCapsStyleable = textAllCapsStyleable;
            return this;
        }

        public TextAttributes build() {
            return new TextAttributes(this);
        }
    }
}

