/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.uibasics.attributes;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.TextView;
import com.github.bijoysingh.uibasics.R;

public class TextAttributes {
    private Context context;
    private AttributeSet attributeSet;
    private int[] attrStyleable;
    private int textStyleable;
    private int textSizeStyleable;
    private int textColorStyleable;
    private int textStyleStyleable;

    public TextAttributes(Builder builder) {
        this.context = builder.context;
        this.attributeSet = builder.attributeSet;
        this.attrStyleable = builder.attrStyleable;
        this.textStyleable = builder.textStyleable;
        this.textColorStyleable = builder.textColorStyleable;
        this.textSizeStyleable = builder.textSizeStyleable;
        this.textStyleStyleable = builder.textStyleStyleable;
    }

    public void set(TextView view) {
        TypedArray typedArray = this.context.getTheme().obtainStyledAttributes(this.attributeSet, this.attrStyleable, 0, 0);
        try {
            view.setText(typedArray.getText(this.textStyleable));
            view.setTextSize(0, typedArray.getDimension(this.textSizeStyleable, this.context.getResources().getDimension(R.dimen.default_text_size)));
            view.setTextColor(typedArray.getColor(this.textColorStyleable, -1));
            if (Build.VERSION.SDK_INT < 23) {
                view.setTextAppearance(this.context, typedArray.getResourceId(this.textStyleStyleable, 0));
            } else {
                view.setTextAppearance(typedArray.getResourceId(this.textStyleStyleable, 0));
            }
        }
        finally {
            typedArray.recycle();
        }
    }

    public static class Builder {
        private Context context;
        private AttributeSet attributeSet;
        private int[] attrStyleable;
        private int textStyleable;
        private int textSizeStyleable;
        private int textColorStyleable;
        private int textStyleStyleable;

        public Builder setContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder setAttributeSet(AttributeSet attributeSet) {
            this.attributeSet = attributeSet;
            return this;
        }

        public Builder setAttrStyleable(int[] attrStyleable) {
            this.attrStyleable = attrStyleable;
            return this;
        }

        public Builder setTextStyleable(int textStyleable) {
            this.textStyleable = textStyleable;
            return this;
        }

        public Builder setTextSizeStyleable(int textSizeStyleable) {
            this.textSizeStyleable = textSizeStyleable;
            return this;
        }

        public Builder setTextColorStyleable(int textColorStyleable) {
            this.textColorStyleable = textColorStyleable;
            return this;
        }

        public Builder setTextStyleStyleable(int textStyleStyleable) {
            this.textStyleStyleable = textStyleStyleable;
            return this;
        }

        public TextAttributes build() {
            return new TextAttributes(this);
        }
    }
}

