/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.uibasics.attributes;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.github.bijoysingh.uibasics.R;

public class ImageAttributes {
    private Context context;
    private AttributeSet attributeSet;
    private int[] attrStyleable;
    private int srcStyleable;
    private int iconTintStyleable;
    private int iconPaddingStyleable;
    private int iconSizeStyleable;

    public ImageAttributes(Builder builder) {
        this.context = builder.context;
        this.attributeSet = builder.attributeSet;
        this.attrStyleable = builder.attrStyleable;
        this.srcStyleable = builder.srcStyleable;
        this.iconTintStyleable = builder.iconTintStyleable;
        this.iconPaddingStyleable = builder.iconPaddingStyleable;
        this.iconSizeStyleable = builder.iconSizeStyleable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(ImageView view) {
        TypedArray typedArray = this.context.getTheme().obtainStyledAttributes(this.attributeSet, this.attrStyleable, 0, 0);
        try {
            int size;
            int imageSrc = typedArray.getResourceId(this.srcStyleable, 0);
            if (imageSrc != 0) {
                view.setImageResource(imageSrc);
            }
            int tintColor = typedArray.getColor(this.iconTintStyleable, -7829368);
            view.setColorFilter(tintColor);
            int padding = (int)typedArray.getDimension(this.iconPaddingStyleable, 0.0f);
            view.setPadding(padding, padding, padding, padding);
            view.getLayoutParams().width = size = (int)typedArray.getDimension(this.iconSizeStyleable, this.context.getResources().getDimension(R.dimen.default_icon));
            view.getLayoutParams().height = size;
        }
        finally {
            typedArray.recycle();
        }
    }

    public static class Builder {
        private Context context;
        private AttributeSet attributeSet;
        private int[] attrStyleable;
        private int srcStyleable;
        private int iconTintStyleable;
        private int iconPaddingStyleable;
        private int iconSizeStyleable;

        public Builder setContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder setAttributeSet(AttributeSet attributeSet) {
            this.attributeSet = attributeSet;
            return this;
        }

        public Builder setAttrStyleable(int[] attrStyleable) {
            this.attrStyleable = attrStyleable;
            return this;
        }

        public Builder setSrcStyleable(int srcStyleable) {
            this.srcStyleable = srcStyleable;
            return this;
        }

        public Builder setIconTintStyleable(int iconTintStyleable) {
            this.iconTintStyleable = iconTintStyleable;
            return this;
        }

        public Builder setIconPaddingStyleable(int iconPaddingStyleable) {
            this.iconPaddingStyleable = iconPaddingStyleable;
            return this;
        }

        public Builder setIconSizeStyleable(int iconSizeStyleable) {
            this.iconSizeStyleable = iconSizeStyleable;
            return this;
        }

        public ImageAttributes build() {
            return new ImageAttributes(this);
        }
    }
}

