/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.uibasics.views;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.bijoysingh.uibasics.R;
import com.github.bijoysingh.uibasics.base.CustomLinearLayout;

public class FigButton
extends CustomLinearLayout {
    private ImageView mIcon;
    private TextView mLabel;

    public FigButton(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FigButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.uibasics__FigButton, 0, 0);
        try {
            this.mIcon.setImageResource(typedArray.getResourceId(R.styleable.uibasics__FigButton_uibasics__src, 0));
            this.mIcon.setColorFilter(typedArray.getColor(R.styleable.uibasics__FigButton_uibasics__icon_tint, -1));
            int padding = (int)typedArray.getDimension(R.styleable.uibasics__FigButton_uibasics__icon_padding, context.getResources().getDimension(R.dimen.uibasics__default_padding));
            this.mIcon.setPadding(padding, padding, padding, padding);
            this.mLabel.setText(typedArray.getText(R.styleable.uibasics__FigButton_uibasics__text));
            this.mLabel.setTextSize(typedArray.getDimension(R.styleable.uibasics__FigButton_uibasics__text_size, context.getResources().getDimension(R.dimen.uibasics__default_text_size)));
            this.mLabel.setTextColor(typedArray.getColor(R.styleable.uibasics__FigButton_uibasics__text_color, -1));
        }
        finally {
            typedArray.recycle();
        }
    }

    public FigButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public FigButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public void init() {
        this.setContentLayout(R.layout.uibasics__fig_button);
        this.setOrientation(0);
        this.mIcon = (ImageView)this.findViewById(R.id.uibasics__icon);
        this.mLabel = (TextView)this.findViewById(R.id.uibasics__label);
    }

    public ImageView getIconView() {
        return this.mIcon;
    }

    public TextView getLabelView() {
        return this.mLabel;
    }

    public void setIconResource(@DrawableRes Integer drawableRes) {
        this.mIcon.setImageResource(drawableRes.intValue());
    }

    public void setIconTint(@ColorRes Integer colorRes) {
        this.mIcon.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)colorRes));
    }

    public void setIconPadding(@DimenRes Integer dimenRes) {
        int padding = (int)this.getContext().getResources().getDimension(dimenRes.intValue());
        this.mIcon.setPadding(padding, padding, padding, padding);
    }

    public void setLabel(@StringRes Integer labelRes) {
        this.mLabel.setText(labelRes.intValue());
    }

    public void setLabelColor(@ColorRes Integer textColorRes) {
        this.mLabel.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)textColorRes));
    }

    public void setLabelSize(@DimenRes Integer dimenRes) {
        int labelSize = (int)this.getContext().getResources().getDimension(dimenRes.intValue());
        this.mLabel.setTextSize((float)labelSize);
    }
}

