/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.server;

import android.app.Activity;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class QueryParams {
    private final String url;
    private final String cache;
    private final Integer queryIdentifier;
    private final Boolean isAuthenticated;
    private final Integer method;
    private final Activity activity;
    private final Fragment fragment;
    private final Map<String, Object> extra;

    private QueryParams(String url, @Nullable String cache, Integer queryIdentifier, Boolean isAuthenticated, @Nullable Integer method, @Nullable Activity activity, @Nullable Fragment fragment, Map<String, Object> extra) {
        this.url = url;
        this.cache = cache;
        this.queryIdentifier = queryIdentifier;
        this.isAuthenticated = isAuthenticated;
        this.method = method;
        this.activity = activity;
        this.fragment = fragment;
        this.extra = extra;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCache() {
        return this.cache;
    }

    public Integer getQueryIdentifier() {
        return this.queryIdentifier;
    }

    public Boolean getAuthenticated() {
        return this.isAuthenticated;
    }

    public Integer getMethod(Integer defaultMethod) {
        return this.method == null ? defaultMethod : this.method;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public Fragment getFragment() {
        return this.fragment;
    }

    public Object getExtra(String key) {
        if (this.extra == null || !this.extra.containsKey(key)) {
            return null;
        }
        return this.extra.get(key);
    }

    public static class Builder {
        private String url;
        private String cache;
        private Integer queryIdentifier;
        private Boolean isAuthenticated;
        private Integer method;
        private Activity activity;
        private Fragment fragment;
        private Map<String, Object> extra;

        public Builder(String url) {
            this.url = url;
            this.cache = null;
            this.queryIdentifier = -1;
            this.isAuthenticated = false;
            this.method = null;
            this.activity = null;
            this.fragment = null;
            this.extra = new HashMap<String, Object>();
        }

        public Builder setCache(String cacheFilename) {
            this.cache = cacheFilename;
            return this;
        }

        public Builder setQueryIdentifier(Integer queryIdentifier) {
            this.queryIdentifier = queryIdentifier;
            return this;
        }

        public Builder setAuthenticated(Boolean authenticated) {
            this.isAuthenticated = authenticated;
            return this;
        }

        public Builder setMethod(Integer method) {
            this.method = method;
            return this;
        }

        public Builder setActivity(Activity activity) {
            this.activity = activity;
            return this;
        }

        public Builder setFragment(Fragment fragment) {
            this.fragment = fragment;
            return this;
        }

        public Builder setExtra(Map<String, Object> extra) {
            this.extra = extra;
            return this;
        }

        public Builder addExtra(String key, Object value) {
            this.extra.put(key, value);
            return this;
        }

        public QueryParams build() {
            return new QueryParams(this.url, this.cache, this.queryIdentifier, this.isAuthenticated, this.method, this.activity, this.fragment, this.extra);
        }
    }
}

