/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateFormatter {
    private static String getDefaultFormat() {
        return Formats.HH_MM_A_DD_MMMM_YYYY.getFormat();
    }

    public static String getToday() {
        return DateFormatter.getToday(DateFormatter.getDefaultFormat());
    }

    public static String getToday(String format) {
        return DateFormatter.getDate(format, Calendar.getInstance());
    }

    public static String getDate(long unixTimestamp) {
        return DateFormatter.getDate(DateFormatter.getDefaultFormat(), unixTimestamp);
    }

    public static String getDate(String format, long unixTimestamp) {
        return DateFormatter.getDate(format, new Date(unixTimestamp), Locale.getDefault());
    }

    public static String getDate(String format, long unixTimestamp, Locale locale) {
        return DateFormatter.getDate(format, new Date(unixTimestamp), locale);
    }

    public static String getDate(Calendar calendar) {
        return DateFormatter.getDate(DateFormatter.getDefaultFormat(), calendar.getTime());
    }

    public static String getDate(String format, Calendar calendar) {
        return DateFormatter.getDate(format, calendar.getTime());
    }

    public static String getDate(Date date) {
        return DateFormatter.getDate(DateFormatter.getDefaultFormat(), date, Locale.getDefault());
    }

    public static String getDate(String format, Date date) {
        return DateFormatter.getDate(format, date, Locale.getDefault());
    }

    public static String getDate(Calendar calendar, Locale locale) {
        return DateFormatter.getDate(DateFormatter.getDefaultFormat(), calendar.getTime(), locale);
    }

    public static String getDate(String format, Calendar calendar, Locale locale) {
        return DateFormatter.getDate(format, calendar.getTime(), locale);
    }

    public static String getDate(Date date, Locale locale) {
        return DateFormatter.getDate(DateFormatter.getDefaultFormat(), date, locale);
    }

    public static String getDate(String format, Date date, Locale locale) {
        SimpleDateFormat timeFormatter = new SimpleDateFormat(format, locale);
        return timeFormatter.format(date);
    }

    public static enum Formats {
        DD_MM_YYYY("dd MM yyyy"),
        DD_MMM_YYYY("dd MMM yyyy"),
        DD_MMMM_YYYY("dd MMM yyyy"),
        HH_MM_SS("HH:mm.ss"),
        HH_MM("HH:mm"),
        HH_MM_A("hh:mm a"),
        HH_MM_SS_A("hh:mm.ss a"),
        HH_MM_DD_MM_YYYY("HH:mm, dd MM yyyy"),
        HH_MM_DD_MMM_YYYY("HH:mm, dd MMM yyyy"),
        HH_MM_DD_MMMM_YYYY("HH:mm, dd MMMM yyyy"),
        HH_MM_A_DD_MM_YYYY("hh:mm a, dd MM yyyy"),
        HH_MM_A_DD_MMM_YYYY("hh:mm a, dd MMM yyyy"),
        HH_MM_A_DD_MMMM_YYYY("hh:mm a, dd MMMM yyyy");

        private String format;

        private Formats(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

