/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.json;

import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class SafeJson
extends JSONObject {
    private SafeJson(JSONObject copyFrom, String[] names) throws JSONException {
        super(copyFrom, names);
    }

    private SafeJson(String json) throws JSONException {
        super(json);
    }

    private SafeJson(JSONTokener readFrom) throws JSONException {
        super(readFrom);
    }

    private SafeJson(Map copyFrom) {
        super(copyFrom);
    }

    private SafeJson() {
    }

    public static SafeJson getInstance() {
        return new SafeJson();
    }

    public static SafeJson getInstance(Map copyFrom) {
        return new SafeJson(copyFrom);
    }

    public static SafeJson getInstance(JSONTokener readFrom) {
        try {
            return new SafeJson(readFrom);
        }
        catch (JSONException exception) {
            return null;
        }
    }

    public static SafeJson getInstance(String json) {
        try {
            return new SafeJson(json);
        }
        catch (JSONException exception) {
            return null;
        }
    }

    public static SafeJson getInstance(JSONObject copyFrom, String[] names) {
        try {
            return new SafeJson(copyFrom, names);
        }
        catch (JSONException exception) {
            return null;
        }
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public Object get(String name) {
        return this.get(name, null);
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public JSONObject getJSONObject(String name) {
        return this.getJSONObject(name, null);
    }

    public JSONArray getJSONArray(String name) {
        return this.getJSONArray(name, null);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    public int getInt(String name, int defaultVal) {
        try {
            return super.getInt(name);
        }
        catch (JSONException exception) {
            return defaultVal;
        }
    }

    public Object get(String name, Object defaultVal) {
        try {
            return super.get(name);
        }
        catch (JSONException exception) {
            return defaultVal;
        }
    }

    public String getString(String name, String defaultVal) {
        try {
            return super.getString(name);
        }
        catch (JSONException exception) {
            return defaultVal;
        }
    }

    public JSONObject getJSONObject(String name, JSONObject defaultVal) {
        try {
            return super.getJSONObject(name);
        }
        catch (JSONException exception) {
            return defaultVal;
        }
    }

    public JSONArray getJSONArray(String name, JSONArray defaultVal) {
        try {
            return super.getJSONArray(name);
        }
        catch (JSONException exception) {
            return defaultVal;
        }
    }

    public boolean getBoolean(String name, boolean defaultVal) {
        try {
            return super.getBoolean(name);
        }
        catch (JSONException exception) {
            return defaultVal;
        }
    }

    public double getDouble(String name, double defaultVal) {
        try {
            return super.getDouble(name);
        }
        catch (JSONException exception) {
            return defaultVal;
        }
    }

    public long getLong(String name, long defaultVal) {
        try {
            return super.getLong(name);
        }
        catch (JSONException exception) {
            return defaultVal;
        }
    }
}

