/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.recyclerview;

import android.content.Context;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.github.bijoysingh.starter.recyclerview.RecyclerViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class RecyclerViewAdapter<T, U extends RecyclerViewHolder<T>>
extends RecyclerView.Adapter<U> {
    protected Context context;
    protected Integer layout;
    protected List<T> contents;
    protected Class<U> type;
    protected boolean isClickEnabled;
    protected Bundle extra;
    protected RecyclerView.LayoutManager layoutManager;

    public RecyclerViewAdapter(Context context, Integer layout, Class<U> type) {
        this.context = context;
        this.layout = layout;
        this.type = type;
        this.contents = new ArrayList<T>();
        this.isClickEnabled = false;
    }

    public void setClickEnabled(boolean clickEnabled) {
        this.isClickEnabled = clickEnabled;
    }

    public void setExtra(Bundle extra) {
        this.extra = extra;
    }

    public void onItemClick(U holder, T item) {
    }

    public U onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(this.layout.intValue(), parent, false);
        try {
            return (U)((Object)((RecyclerViewHolder)((Object)this.type.getConstructor(Context.class, View.class).newInstance(this.context, v))));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void onBindViewHolder(U holder, int position) {
        T data = this.getItems().get(position);
        if (this.isClickEnabled) {
            ((RecyclerViewHolder)((Object)holder)).itemView.setOnClickListener(new View.OnClickListener((RecyclerViewHolder)((Object)holder), data){
                final /* synthetic */ RecyclerViewHolder val$holder;
                final /* synthetic */ Object val$data;
                {
                    this.val$holder = recyclerViewHolder;
                    this.val$data = object;
                }

                public void onClick(View view) {
                    RecyclerViewAdapter.this.onItemClick(this.val$holder, this.val$data);
                }
            });
        }
        ((RecyclerViewHolder)((Object)holder)).populate(data, this.extra);
    }

    public int getItemCount() {
        return this.getItems().size();
    }

    public List<T> getItems() {
        return this.contents;
    }

    public void setItems(List<T> list) {
        this.contents = list;
        this.notifyDataSetChanged();
    }

    public void addItem(T item, int position) {
        this.contents.add(position, item);
        this.notifyItemInserted(position);
    }

    public void updateItem(T item, int position) {
        this.contents.remove(position);
        this.contents.add(position, item);
        this.notifyItemChanged(position);
    }

    public void addItem(T item) {
        this.contents.add(item);
        this.notifyItemInserted(this.contents.size() - 1);
    }

    public void addItems(List<T> items) {
        this.contents.addAll(items);
        this.notifyItemRangeInserted(this.contents.size() - items.size() - 1, items.size());
    }

    public void removeItem(T item) {
        int position = this.contents.indexOf(item);
        if (position != -1) {
            this.removeItem(position);
        }
    }

    public void clearItems() {
        this.contents.clear();
        this.notifyDataSetChanged();
    }

    public void removeItem(int position) {
        this.contents.remove(position);
        this.notifyItemRemoved(position);
    }

    public LinearLayoutManager getLinearLayoutManager() {
        if (this.layoutManager == null || !(this.layoutManager instanceof LinearLayoutManager)) {
            this.layoutManager = new LinearLayoutManager(this.context);
        }
        return (LinearLayoutManager)this.layoutManager;
    }

    public GridLayoutManager getGridLayoutManager(int columns) {
        if (this.layoutManager == null || !(this.layoutManager instanceof GridLayoutManager)) {
            this.layoutManager = new GridLayoutManager(this.context, columns);
        }
        return (GridLayoutManager)this.layoutManager;
    }
}

