package com.github.bijoysingh.starter.util;

import java.math.BigInteger;
import java.security.SecureRandom;

/**
 * Some common function used often and are difficult to classify
 * Created by bijoy on 5/12/17.
 */

public class RandomHelper {

  public static String getRandom() {
    return new BigInteger(32, getSecureRandom()).toString(32);
  }

  public static String getRandomString(int length) {
    return new BigInteger(length * 5, getSecureRandom()).toString(32);
  }

  public static BigInteger getRandomInteger(int length) {
    int size = (int) Math.ceil(Math.log(Math.pow(10.0, length)) / Math.log(2));
    return new BigInteger(size, RandomHelper.getSecureRandom());
  }

  public static BigInteger getRandomIntegerBits(int bits) {
    return new BigInteger(bits, RandomHelper.getSecureRandom());
  }

  private static SecureRandom getSecureRandom() {
    return new SecureRandom();
  }
}
