package com.github.bijoysingh.starter.util;

import android.util.Log;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * Simple class to log timed content in code
 * Created by bijoy on 2/8/17.
 */

public class SimpleProfiler {

  private String tag;
  private int logMode;

  private long startMillis;

  public SimpleProfiler(String tag, int logMode) {
    this.tag = tag;
    this.logMode = logMode;
  }

  public static class Builder {
    private String tag;
    private int logMode;

    public Builder() {
      tag = SimpleProfiler.class.getSimpleName();
      logMode = Log.DEBUG;
    }

    public Builder setTag(String tag) {
      this.tag = tag;
      return this;
    }

    public Builder setLogMode(int logMode) {
      this.logMode = logMode;
      return this;
    }

    public SimpleProfiler build() {
      return new SimpleProfiler(tag, logMode);
    }
  }

  public void start() {
    startMillis = System.currentTimeMillis();
  }

  public void capture() {
    logEvent("null", System.currentTimeMillis());
  }

  public void capture(String tag) {
    logEvent(tag, System.currentTimeMillis());
  }

  private void logEvent(String event, long millis) {
    Map<String, Object> log = new HashMap<>();
    log.put("event", event);
    log.put("system_time(ms)", millis);
    log.put("since_start(ms)", millis - startMillis);
    Log.println(logMode, tag, new JSONObject(log).toString());
  }
}
