/*
 * Decompiled with CFR 0.152.
 */
package com.acutecoder.pdf.ui;

import android.content.Context;
import android.content.res.ColorStateList;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import androidx.core.graphics.ColorUtils;
import com.acutecoder.pdf.ui.Zoom;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a#\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\u0006\u001a\u0014\u0010\u0007\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0000\u001a\f\u0010\r\u001a\u00020\u000b*\u00020\u000eH\u0000\u001a\u0014\u0010\u000f\u001a\u00020\t*\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0000\u001a\f\u0010\u0011\u001a\u00020\u0004*\u00020\u0012H\u0000\u001a\f\u0010\u0013\u001a\u00020\u0004*\u00020\u0004H\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u000b*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u000b*\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0018\u001a\u00020\u000b*\u00020\u000eH\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u0001*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0001H\u0000\u00a8\u0006\u001c"}, d2={"findSelectedOption", "", "options", "", "", "currentValue", "([Ljava/lang/String;Ljava/lang/String;)I", "formatZoom", "zoom", "", "requestKeyboard", "", "Landroid/widget/EditText;", "hideKeyboard", "Landroid/view/View;", "checkNaN", "valueIfNaN", "formatToSize", "", "formatToDate", "setTintModes", "Landroid/widget/ImageView;", "color", "setBgTintModes", "removeFromParent", "dpToPx", "Landroid/content/Context;", "dp", "ui_release"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\ncom/acutecoder/pdf/ui/ExtensionsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,124:1\n13474#2,3:125\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\ncom/acutecoder/pdf/ui/ExtensionsKt\n*L\n17#1:125,3\n*E\n"})
public final class ExtensionsKt {
    /*
     * WARNING - void declaration
     */
    public static final int findSelectedOption(@NotNull String[] options, @NotNull String currentValue) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
        String[] $this$forEachIndexed$iv = options;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (String item$iv : $this$forEachIndexed$iv) {
            void option;
            int n = index$iv++;
            String string = item$iv;
            int index = n;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)option, (Object)currentValue)) continue;
            return index;
        }
        return -1;
    }

    @NotNull
    public static final String formatZoom(@NotNull String $this$formatZoom, float zoom) {
        Intrinsics.checkNotNullParameter((Object)$this$formatZoom, (String)"<this>");
        String string = $this$formatZoom;
        return Intrinsics.areEqual((Object)string, (Object)Zoom.AUTOMATIC.getValue$ui_release()) ? "Zoom (Auto)" : (Intrinsics.areEqual((Object)string, (Object)Zoom.PAGE_FIT.getValue$ui_release()) ? "Zoom (Page Fit)" : (Intrinsics.areEqual((Object)string, (Object)Zoom.PAGE_WIDTH.getValue$ui_release()) ? "Zoom (Page Width)" : (Intrinsics.areEqual((Object)string, (Object)Zoom.ACTUAL_SIZE.getValue$ui_release()) ? "Zoom (Actual Size)" : "Zoom (" + MathKt.roundToInt((float)(zoom * (float)100)) + "%)")));
    }

    public static final void requestKeyboard(@NotNull EditText $this$requestKeyboard) {
        Intrinsics.checkNotNullParameter((Object)$this$requestKeyboard, (String)"<this>");
        $this$requestKeyboard.requestFocus();
        Object object = $this$requestKeyboard.getContext().getSystemService("input_method");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        InputMethodManager inputMethodManager = (InputMethodManager)object;
        inputMethodManager.showSoftInput((View)$this$requestKeyboard, 1);
    }

    public static final void hideKeyboard(@NotNull View $this$hideKeyboard) {
        Intrinsics.checkNotNullParameter((Object)$this$hideKeyboard, (String)"<this>");
        Object object = $this$hideKeyboard.getContext().getSystemService("input_method");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        InputMethodManager inputMethodManager = (InputMethodManager)object;
        inputMethodManager.hideSoftInputFromWindow($this$hideKeyboard.getWindowToken(), 0);
    }

    public static final float checkNaN(float $this$checkNaN, float valueIfNaN) {
        return Float.isNaN($this$checkNaN) ? valueIfNaN : $this$checkNaN;
    }

    @NotNull
    public static final String formatToSize(long $this$formatToSize) {
        String unit;
        if ($this$formatToSize <= 0L) {
            return "0 B";
        }
        double value = switch (unit = $this$formatToSize < 1024L ? "B" : ($this$formatToSize < 0x100000L ? "KB" : ($this$formatToSize < 0x40000000L ? "MB" : ($this$formatToSize < 0x10000000000L ? "GB" : ($this$formatToSize < 0x4000000000000L ? "TB" : "PB"))))) {
            case "B" -> $this$formatToSize;
            case "KB" -> (double)$this$formatToSize / 1024.0;
            case "MB" -> (double)$this$formatToSize / 1048576.0;
            case "GB" -> (double)$this$formatToSize / 1.073741824E9;
            case "TB" -> (double)$this$formatToSize / 1.099511627776E12;
            case "PB" -> (double)$this$formatToSize / 1.125899906842624E15;
            default -> 0.0;
        };
        String string = "%.1f %s";
        Object[] objectArray = new Object[]{value, unit};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public static final String formatToDate(@NotNull String $this$formatToDate) {
        String cleanDate;
        Intrinsics.checkNotNullParameter((Object)$this$formatToDate, (String)"<this>");
        if (StringsKt.startsWith$default((String)$this$formatToDate, (String)"D:", (boolean)false, (int)2, null)) {
            String string = $this$formatToDate.substring(2);
            v1 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        } else {
            v1 = cleanDate = $this$formatToDate;
        }
        if (cleanDate.length() < 14) {
            return $this$formatToDate;
        }
        String string = cleanDate.substring(0, 14);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String rawDate = string;
        SimpleDateFormat parser = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault());
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss a", Locale.getDefault());
        Date date = parser.parse(rawDate);
        if (date == null) {
            return "Invalid Date";
        }
        Date date2 = date;
        String string2 = formatter.format(date2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static final void setTintModes(@NotNull ImageView $this$setTintModes, int color) {
        Intrinsics.checkNotNullParameter((Object)$this$setTintModes, (String)"<this>");
        Object object = new int[2][];
        int[] nArray = new int[]{16842910};
        object[0] = nArray;
        nArray = new int[]{-16842910};
        object[1] = nArray;
        int[][] nArrayArray = object;
        object = new int[2];
        object[0] = (int[])color;
        object[1] = (int[])ColorUtils.setAlphaComponent((int)color, (int)150);
        $this$setTintModes.setImageTintList(new ColorStateList((int[][])nArrayArray, (int[])object));
    }

    public static final void setBgTintModes(@NotNull View $this$setBgTintModes, int color) {
        Intrinsics.checkNotNullParameter((Object)$this$setBgTintModes, (String)"<this>");
        Object object = new int[2][];
        int[] nArray = new int[]{16842910};
        object[0] = nArray;
        nArray = new int[]{-16842910};
        object[1] = nArray;
        int[][] nArrayArray = object;
        object = new int[2];
        object[0] = (int[])color;
        object[1] = (int[])ColorUtils.setAlphaComponent((int)color, (int)150);
        $this$setBgTintModes.setBackgroundTintList(new ColorStateList((int[][])nArrayArray, (int[])object));
    }

    public static final void removeFromParent(@NotNull View $this$removeFromParent) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$removeFromParent, (String)"<this>");
            ViewParent viewParent = $this$removeFromParent.getParent();
            if (viewParent == null) break block1;
            ViewParent it = viewParent;
            boolean bl = false;
            if (it instanceof ViewGroup) {
                ((ViewGroup)it).removeView($this$removeFromParent);
            }
        }
    }

    public static final int dpToPx(@NotNull Context $this$dpToPx, int dp) {
        Intrinsics.checkNotNullParameter((Object)$this$dpToPx, (String)"<this>");
        return MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)$this$dpToPx.getResources().getDisplayMetrics()));
    }
}

