/*
 * Decompiled with CFR 0.152.
 */
package com.acutecoder.pdf.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R&\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00078\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00078\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/acutecoder/pdf/ui/ColorItemView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "color", "getColor", "()I", "setColor", "(I)V", "borderColor", "getBorderColor", "setBorderColor", "fillPaint", "Landroid/graphics/Paint;", "borderPaint", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "ui_release"})
public final class ColorItemView
extends View {
    @ColorInt
    private int color;
    @ColorInt
    private int borderColor;
    @NotNull
    private final Paint fillPaint;
    @NotNull
    private final Paint borderPaint;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public ColorItemView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void $this$borderPaint_u24lambda_u241;
        Paint $this$fillPaint_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.color = -7829368;
        this.borderColor = -16777216;
        Paint paint2 = paint = new Paint();
        ColorItemView colorItemView = this;
        boolean bl = false;
        $this$fillPaint_u24lambda_u240.setStyle(Paint.Style.FILL);
        $this$fillPaint_u24lambda_u240.setAntiAlias(true);
        colorItemView.fillPaint = paint;
        $this$fillPaint_u24lambda_u240 = paint = new Paint();
        colorItemView = this;
        boolean bl2 = false;
        $this$borderPaint_u24lambda_u241.setStyle(Paint.Style.STROKE);
        $this$borderPaint_u24lambda_u241.setStrokeWidth(5.0f);
        $this$borderPaint_u24lambda_u241.setAntiAlias(true);
        colorItemView.borderPaint = paint;
    }

    public /* synthetic */ ColorItemView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int value) {
        this.color = value;
        this.postInvalidate();
    }

    public final int getBorderColor() {
        return this.borderColor;
    }

    public final void setBorderColor(int value) {
        this.borderColor = value;
        this.postInvalidate();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        int availableWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int availableHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int diameter = RangesKt.coerceAtMost((int)availableWidth, (int)availableHeight);
        float radius = (float)diameter / 2.0f;
        float centerX = (float)this.getPaddingLeft() + (float)availableWidth / 2.0f;
        float centerY = (float)this.getPaddingTop() + (float)availableHeight / 2.0f;
        this.fillPaint.setColor(this.color);
        this.borderPaint.setColor(this.borderColor);
        canvas.drawCircle(centerX, centerY, radius, this.fillPaint);
        canvas.drawCircle(centerX, centerY, radius, this.borderPaint);
    }

    @JvmOverloads
    public ColorItemView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ColorItemView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

