/*
 * Decompiled with CFR 0.152.
 */
package com.github.bhlangonijr.chesslib.util;

import java.util.Map;

public class StringUtil {
    public static String lastSequence(String str, int size) {
        return str.substring(str.length() - size);
    }

    public static String afterSequence(String str, String seq, int size) {
        int idx = str.indexOf(seq) + seq.length();
        if (idx == 0) {
            return "";
        }
        return str.substring(idx, idx + size);
    }

    public static String afterSequence(String str, String seq) {
        int idx = str.indexOf(seq) + seq.length();
        if (idx == 0) {
            return "";
        }
        return str.substring(idx);
    }

    public static String beforeSequence(String str, String seq) {
        int idx = str.indexOf(seq);
        if (idx == -1) {
            return str;
        }
        return str.substring(0, idx);
    }

    public static String normalize(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (i < str.length() - 1 && str.charAt(i) == ' ' && str.charAt(i + 1) == ' ') continue;
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static StringBuilder replaceAll(StringBuilder builder, String from, String to) {
        int index = builder.indexOf(from);
        while (index != -1) {
            builder.replace(index, index + from.length(), to);
            index += to.length();
            index = builder.indexOf(from, index);
        }
        return builder;
    }

    public static void translate(StringBuilder str, char[] table) {
        for (int idx = 0; idx < str.length(); ++idx) {
            char ch = str.charAt(idx);
            if (ch >= table.length) continue;
            ch = table[ch];
            str.setCharAt(idx, ch);
        }
    }

    public static void translate(StringBuilder str, Map<Character, Character> table) {
        for (int idx = 0; idx < str.length(); ++idx) {
            char ch = str.charAt(idx);
            Character conversion = table.get(Character.valueOf(ch));
            if (conversion == null) continue;
            str.setCharAt(idx, conversion.charValue());
        }
    }

    public static int countOccurrences(String str, char charToCount) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != charToCount) continue;
            ++count;
        }
        return count;
    }
}

