/*
 * Decompiled with CFR 0.152.
 */
package com.github.bhlangonijr.chesslib.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;

public class LargeFile
implements Iterable<String>,
AutoCloseable {
    private final BufferedReader reader;
    private String nextLine;

    public LargeFile(String filePath) throws Exception {
        this.reader = new BufferedReader(new FileReader(filePath));
        this.readNextLine();
    }

    public LargeFile(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.readNextLine();
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new FileIterator();
    }

    private void readNextLine() {
        try {
            this.nextLine = this.reader.readLine();
        }
        catch (Exception ex) {
            this.nextLine = null;
            throw new IllegalStateException("Error reading file", ex);
        }
    }

    private class FileIterator
    implements Iterator<String> {
        private FileIterator() {
        }

        @Override
        public boolean hasNext() {
            return LargeFile.this.nextLine != null;
        }

        @Override
        public String next() {
            String currentLine = LargeFile.this.nextLine;
            LargeFile.this.readNextLine();
            return currentLine;
        }

        @Override
        public void remove() {
        }
    }
}

