/*
 * Decompiled with CFR 0.152.
 */
package com.github.bhlangonijr.chesslib.pgn;

import com.github.bhlangonijr.chesslib.util.StringUtil;
import java.util.regex.Pattern;

public class PgnProperty {
    public static final String UTF8_BOM = "\ufeff";
    private static final Pattern propertyPattern = Pattern.compile("\\[.* \".*\"\\]");
    public String name;
    public String value;

    public PgnProperty() {
    }

    public PgnProperty(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static boolean isProperty(String line) {
        return propertyPattern.matcher(line).matches();
    }

    public static PgnProperty parsePgnProperty(String line) {
        try {
            String l = line.replace("[", "");
            l = l.replace("]", "");
            l = l.replace("\"", "");
            return new PgnProperty(StringUtil.beforeSequence(l, " "), StringUtil.afterSequence(l, " "));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

