/*
 * Decompiled with CFR 0.152.
 */
package com.github.bhlangonijr.chesslib.pgn;

import com.github.bhlangonijr.chesslib.game.Game;
import com.github.bhlangonijr.chesslib.pgn.GameLoader;
import com.github.bhlangonijr.chesslib.util.LargeFile;
import java.util.Iterator;

public class PgnIterator
implements Iterable<Game>,
AutoCloseable {
    private final Iterator<String> pgnLines;
    private Game game;

    public PgnIterator(String filename) throws Exception {
        this(new LargeFile(filename));
    }

    public PgnIterator(LargeFile file) {
        this.pgnLines = file.iterator();
        this.loadNextGame();
    }

    public PgnIterator(Iterable<String> pgnLines) {
        this.pgnLines = pgnLines.iterator();
        this.loadNextGame();
    }

    public PgnIterator(Iterator<String> pgnLines) {
        this.pgnLines = pgnLines;
        this.loadNextGame();
    }

    @Override
    public Iterator<Game> iterator() {
        return new GameIterator();
    }

    @Override
    public void close() throws Exception {
        if (this.pgnLines instanceof LargeFile) {
            ((LargeFile)((Object)this.pgnLines)).close();
        }
    }

    private void loadNextGame() {
        this.game = GameLoader.loadNextGame(this.pgnLines);
    }

    private class GameIterator
    implements Iterator<Game> {
        private GameIterator() {
        }

        @Override
        public boolean hasNext() {
            return PgnIterator.this.game != null;
        }

        @Override
        public Game next() {
            Game current = PgnIterator.this.game;
            PgnIterator.this.loadNextGame();
            return current;
        }

        @Override
        public void remove() {
        }
    }
}

