/*
 * Decompiled with CFR 0.152.
 */
package com.github.bhlangonijr.chesslib.pgn;

import com.github.bhlangonijr.chesslib.game.Event;
import com.github.bhlangonijr.chesslib.game.Game;
import com.github.bhlangonijr.chesslib.game.Player;
import com.github.bhlangonijr.chesslib.game.Round;
import com.github.bhlangonijr.chesslib.pgn.PgnIterator;
import com.github.bhlangonijr.chesslib.pgn.PgnLoadListener;
import com.github.bhlangonijr.chesslib.util.LargeFile;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgnHolder {
    private final Map<String, Event> event = new HashMap<String, Event>();
    private final Map<String, Player> player = new HashMap<String, Player>();
    private final List<Game> games = new ArrayList<Game>();
    private final List<PgnLoadListener> listener = new ArrayList<PgnLoadListener>();
    private String fileName;
    private Integer size;
    private boolean lazyLoad;

    public PgnHolder(String filename) {
        this.setFileName(filename);
        this.setLazyLoad(false);
    }

    public void cleanUp() {
        this.event.clear();
        this.player.clear();
        this.games.clear();
        this.listener.clear();
        this.size = 0;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Map<String, Event> getEvent() {
        return this.event;
    }

    public Map<String, Player> getPlayer() {
        return this.player;
    }

    public List<Game> getGames() {
        return this.games;
    }

    public List<Game> getGame() {
        return this.games;
    }

    public void loadPgn() throws Exception {
        this.loadPgn(new LargeFile(this.getFileName()));
    }

    public long countGamesInPgnFile() throws IOException {
        return Files.lines(Paths.get(this.fileName, new String[0])).filter(s -> s.startsWith("[Event ")).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPgn(LargeFile file) throws Exception {
        this.size = 0;
        PgnIterator games = new PgnIterator(file);
        try {
            for (Game game : games) {
                this.addGame(game);
            }
        }
        finally {
            file.close();
        }
    }

    public void loadPgn(String pgn) {
        List<String> iterable = Arrays.asList(pgn.split("\n"));
        PgnIterator games = new PgnIterator(iterable.iterator());
        for (Game game : games) {
            this.addGame(game);
        }
    }

    public void savePgn() {
        try {
            FileWriter outFile = new FileWriter(this.getFileName());
            PrintWriter out = new PrintWriter(outFile);
            for (Event event : this.getEvent().values()) {
                for (Round round : event.getRound().values()) {
                    for (Game game : round.getGame()) {
                        if (game == null) continue;
                        out.println();
                        out.print(game);
                        out.println();
                    }
                }
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Integer getSize() {
        return this.size;
    }

    public boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public void setLazyLoad(boolean lazyLoad) {
        this.lazyLoad = lazyLoad;
    }

    public List<PgnLoadListener> getListener() {
        return this.listener;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Event event : this.getEvent().values()) {
            for (Round round : event.getRound().values()) {
                for (Game game : round.getGame()) {
                    if (game == null) continue;
                    sb.append('\n');
                    sb.append(game);
                    sb.append('\n');
                }
            }
        }
        return sb.toString();
    }

    private void addGame(Game game) {
        Player blackPlayer;
        Player whitePlayer;
        Event event = this.getEvent().get(game.getRound().getEvent().getName());
        if (event == null) {
            this.getEvent().put(game.getRound().getEvent().getName(), game.getRound().getEvent());
        }
        if ((whitePlayer = this.getPlayer().get(game.getWhitePlayer().getId())) == null) {
            this.getPlayer().put(game.getWhitePlayer().getId(), game.getWhitePlayer());
        }
        if ((blackPlayer = this.getPlayer().get(game.getBlackPlayer().getId())) == null) {
            this.getPlayer().put(game.getBlackPlayer().getId(), game.getBlackPlayer());
        }
        this.games.add(game);
        this.getListener().forEach(pgnLoadListener -> pgnLoadListener.notifyProgress(this.games.size()));
    }
}

