/*
 * Decompiled with CFR 0.152.
 */
package com.github.bhlangonijr.chesslib.move;

import com.github.bhlangonijr.chesslib.BoardEvent;
import com.github.bhlangonijr.chesslib.BoardEventType;
import com.github.bhlangonijr.chesslib.Piece;
import com.github.bhlangonijr.chesslib.Side;
import com.github.bhlangonijr.chesslib.Square;

public class Move
implements BoardEvent {
    private final Square from;
    private final Square to;
    private final Piece promotion;
    private String san;

    public Move(Square from, Square to) {
        this(from, to, Piece.NONE);
    }

    public Move(Square from, Square to, Piece promotion) {
        this.promotion = promotion;
        this.from = from;
        this.to = to;
    }

    public Move(String move, Side side) {
        this(Square.valueOf(move.substring(0, 2).toUpperCase()), Square.valueOf(move.substring(2, 4).toUpperCase()), move.length() < 5 ? Piece.NONE : (Side.WHITE.equals((Object)side) ? Piece.fromFenSymbol(move.substring(4, 5).toUpperCase()) : Piece.fromFenSymbol(move.substring(4, 5).toLowerCase())));
    }

    public Square getFrom() {
        return this.from;
    }

    public Square getTo() {
        return this.to;
    }

    public Piece getPromotion() {
        return this.promotion;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Move)) {
            return false;
        }
        Move move = (Move)obj;
        return move.getFrom().equals((Object)this.getFrom()) && move.getTo().equals((Object)this.getTo()) && move.getPromotion().equals((Object)this.getPromotion());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        String promo = "";
        if (!Piece.NONE.equals((Object)this.promotion)) {
            promo = this.promotion.getFenSymbol();
        }
        return this.from.toString().toLowerCase() + this.to.toString().toLowerCase() + promo.toLowerCase();
    }

    @Override
    public BoardEventType getType() {
        return BoardEventType.ON_MOVE;
    }

    public String getSan() {
        return this.san;
    }

    public void setSan(String san) {
        this.san = san;
    }
}

