/*
 * Decompiled with CFR 0.152.
 */
package com.github.bhlangonijr.chesslib.game;

import com.github.bhlangonijr.chesslib.Board;
import com.github.bhlangonijr.chesslib.game.GameResult;
import com.github.bhlangonijr.chesslib.game.Player;
import com.github.bhlangonijr.chesslib.game.Round;
import com.github.bhlangonijr.chesslib.game.Termination;
import com.github.bhlangonijr.chesslib.move.Move;
import com.github.bhlangonijr.chesslib.move.MoveConversionException;
import com.github.bhlangonijr.chesslib.move.MoveException;
import com.github.bhlangonijr.chesslib.move.MoveList;
import com.github.bhlangonijr.chesslib.pgn.PgnException;
import com.github.bhlangonijr.chesslib.util.StringUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Game {
    private final Round round;
    private String gameId;
    private String date;
    private String time;
    private Termination termination;
    private Player whitePlayer;
    private Player blackPlayer;
    private String annotator;
    private String plyCount;
    private GameResult result;
    private MoveList halfMoves = new MoveList();
    private Map<Integer, MoveList> variations;
    private Map<Integer, String> comments;
    private Map<Integer, String> nag;
    private Map<String, String> property;
    private String fen;
    private Board board;
    private int position;
    private int initialPosition;
    private MoveList currentMoveList;
    private String eco;
    private StringBuilder moveText;
    private String opening;
    private String variation;

    public Game(String gameId, Round round) {
        this.gameId = gameId;
        this.round = round;
        this.result = GameResult.ONGOING;
        this.initialPosition = 0;
        this.setPosition(0);
    }

    private static String makeProp(String name, String value) {
        return "[" + name + " \"" + value + "\"]\n";
    }

    private static String getMovesAt(String moves, int index) {
        StringBuilder b = new StringBuilder();
        int count = 0;
        for (String m : moves.split(" ")) {
            if (++count >= index) break;
            b.append(m);
            b.append(' ');
        }
        return b.toString();
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public Termination getTermination() {
        return this.termination;
    }

    public void setTermination(Termination termination) {
        this.termination = termination;
    }

    public Player getWhitePlayer() {
        return this.whitePlayer;
    }

    public void setWhitePlayer(Player whitePlayer) {
        this.whitePlayer = whitePlayer;
    }

    public Player getBlackPlayer() {
        return this.blackPlayer;
    }

    public void setBlackPlayer(Player blackPlayer) {
        this.blackPlayer = blackPlayer;
    }

    public String getAnnotator() {
        return this.annotator;
    }

    public void setAnnotator(String annotator) {
        this.annotator = annotator;
    }

    public String getPlyCount() {
        return this.plyCount;
    }

    public void setPlyCount(String plyCount) {
        this.plyCount = plyCount;
    }

    public GameResult getResult() {
        return this.result;
    }

    public void setResult(GameResult result) {
        this.result = result;
    }

    public Map<Integer, MoveList> getVariations() {
        return this.variations;
    }

    public void setVariations(Map<Integer, MoveList> variations) {
        this.variations = variations;
    }

    public Map<Integer, String> getComments() {
        return this.comments;
    }

    public void setComments(Map<Integer, String> comments) {
        this.comments = comments;
    }

    public Map<Integer, String> getNag() {
        return this.nag;
    }

    public void setNag(Map<Integer, String> nag) {
        this.nag = nag;
    }

    public MoveList getHalfMoves() {
        if (this.halfMoves == null) {
            this.halfMoves = this.getFen() != null && !this.getFen().trim().equals("") ? new MoveList(this.getFen()) : new MoveList();
        }
        return this.halfMoves;
    }

    public void setHalfMoves(MoveList halfMoves) {
        this.halfMoves = halfMoves;
        this.setCurrentMoveList(halfMoves);
    }

    public String getFen() {
        return this.fen;
    }

    public void setFen(String fen) {
        this.fen = fen;
    }

    public Board getBoard() {
        return this.board;
    }

    public void setBoard(Board board) {
        this.board = board;
    }

    public Round getRound() {
        return this.round;
    }

    public String toPgn(boolean includeVariations, boolean includeComments) throws MoveConversionException {
        StringBuilder sb = new StringBuilder();
        sb.append(Game.makeProp("Event", this.getRound().getEvent().getName()));
        sb.append(Game.makeProp("Site", this.getRound().getEvent().getSite()));
        sb.append(Game.makeProp("Date", this.getRound().getEvent().getStartDate()));
        sb.append(Game.makeProp("Round", this.getRound().getNumber() + ""));
        sb.append(Game.makeProp("White", this.getWhitePlayer().getName()));
        sb.append(Game.makeProp("Black", this.getBlackPlayer().getName()));
        sb.append(Game.makeProp("Result", this.getResult().getDescription()));
        sb.append(Game.makeProp("PlyCount", this.getPlyCount()));
        if (this.getTermination() != null) {
            sb.append(Game.makeProp("Termination", this.getTermination().toString().toLowerCase()));
        }
        if (this.getRound().getEvent().getTimeControl() != null) {
            sb.append(Game.makeProp("TimeControl", this.getRound().getEvent().getTimeControl().toPGNString()));
        } else {
            sb.append(Game.makeProp("TimeControl", "-"));
        }
        if (this.getAnnotator() != null && !this.getAnnotator().equals("")) {
            sb.append(Game.makeProp("Annotator", this.getAnnotator()));
        }
        if (this.getFen() != null && !this.getFen().equals("")) {
            sb.append(Game.makeProp("FEN", this.getFen()));
        }
        if (this.getEco() != null && !this.getEco().equals("")) {
            sb.append(Game.makeProp("ECO", this.getEco()));
        }
        if (this.getOpening() != null && !this.getOpening().equals("")) {
            sb.append(Game.makeProp("Opening", this.getOpening()));
        }
        if (this.getWhitePlayer().getElo() > 0) {
            sb.append(Game.makeProp("WhiteElo", this.getWhitePlayer().getElo() + ""));
        }
        if (this.getBlackPlayer().getElo() > 0) {
            sb.append(Game.makeProp("BlackElo", this.getBlackPlayer().getElo() + ""));
        }
        if (this.getProperty() != null) {
            for (Map.Entry<String, String> entry : this.getProperty().entrySet()) {
                sb.append(Game.makeProp(entry.getKey(), entry.getValue()));
            }
        }
        sb.append('\n');
        int index = 0;
        int moveCounter = this.getInitialPosition() + 1;
        int variantIndex = 0;
        int lastSize = sb.length();
        if (this.getHalfMoves().size() == 0) {
            sb.append(this.getMoveText().toString());
        } else {
            sb.append(moveCounter);
            if (moveCounter % 2 == 0) {
                sb.append(".. ");
            } else {
                sb.append(". ");
            }
            String[] sanArray = this.getHalfMoves().toSanArray();
            for (int i = 0; i < sanArray.length; ++i) {
                MoveList var;
                String comment;
                String nag;
                String san = sanArray[i];
                ++index;
                ++variantIndex;
                sb.append(san);
                sb.append(' ');
                if (sb.length() - lastSize > 80) {
                    sb.append("\n");
                    lastSize = sb.length();
                }
                if (this.getNag() != null && (nag = this.getNag().get(variantIndex)) != null) {
                    sb.append(nag);
                    sb.append(' ');
                }
                if (this.getComments() != null && (comment = this.getComments().get(variantIndex)) != null) {
                    sb.append("{");
                    sb.append(comment);
                    sb.append("}");
                }
                if (this.getVariations() != null && (var = this.getVariations().get(variantIndex)) != null) {
                    variantIndex = this.translateVariation(sb, var, -1, variantIndex, index, moveCounter, lastSize);
                    if (index % 2 != 0) {
                        sb.append(moveCounter);
                        sb.append("... ");
                    }
                }
                if (i >= sanArray.length - 1 || index % 2 != 0 || index < 2) continue;
                sb.append(++moveCounter);
                sb.append(". ");
            }
        }
        sb.append(this.getResult().getDescription());
        return sb.toString();
    }

    private int translateVariation(StringBuilder sb, MoveList variation, int parent, int variantIndex, int index, int moveCounter, int lastSize) throws MoveConversionException {
        int variantIndexOld = variantIndex;
        if (variation != null) {
            boolean terminated = false;
            sb.append("(");
            int i = 0;
            int mc = moveCounter;
            int idx = index;
            String[] sanArray = variation.toSanArray();
            for (i = 0; i < sanArray.length; ++i) {
                String sanMove = sanArray[i];
                if (i == 0) {
                    sb.append(mc);
                    if (idx % 2 == 0) {
                        sb.append("... ");
                    } else {
                        sb.append(". ");
                    }
                }
                sb.append(sanMove);
                sb.append(' ');
                MoveList child = this.getVariations().get(++variantIndex);
                if (child != null) {
                    if (i == sanArray.length - 1 && variantIndexOld != child.getParent()) {
                        terminated = true;
                        sb.append(") ");
                    }
                    variantIndex = this.translateVariation(sb, child, variantIndexOld, variantIndex, idx, mc, lastSize);
                }
                if (idx % 2 == 0 && idx >= 2 && i < sanArray.length - 1) {
                    sb.append(++mc);
                    sb.append(". ");
                }
                ++idx;
            }
            if (!terminated) {
                sb.append(") ");
            }
        }
        return variantIndex;
    }

    public String toString() {
        try {
            return this.toPgn(true, true);
        }
        catch (MoveConversionException e) {
            return null;
        }
    }

    public String getGameId() {
        return this.gameId;
    }

    public void setGameId(String gameId) {
        this.gameId = gameId;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getInitialPosition() {
        return this.initialPosition;
    }

    public void setInitialPosition(int initialPosition) {
        this.initialPosition = initialPosition;
    }

    public MoveList getCurrentMoveList() {
        return this.currentMoveList;
    }

    public void setCurrentMoveList(MoveList currentMoveList) {
        this.currentMoveList = currentMoveList;
    }

    public String getEco() {
        return this.eco;
    }

    public void setEco(String eco) {
        this.eco = eco;
    }

    public String getOpening() {
        return this.opening;
    }

    public void setOpening(String opening) {
        this.opening = opening;
    }

    public String getVariation() {
        return this.variation;
    }

    public void setVariation(String variation) {
        this.variation = variation;
    }

    public StringBuilder getMoveText() {
        return this.moveText;
    }

    public void setMoveText(StringBuilder moveText) {
        this.moveText = moveText;
    }

    public void loadMoveText() throws Exception {
        if (this.getMoveText() != null) {
            this.loadMoveText(this.getMoveText());
        }
    }

    public void loadMoveText(StringBuilder moveText) throws Exception {
        if (this.getVariations() != null) {
            this.getVariations().clear();
        }
        if (this.getComments() != null) {
            this.getComments().clear();
        }
        if (this.getNag() != null) {
            this.getNag().clear();
        }
        StringUtil.replaceAll(moveText, "\n", " \n ");
        StringUtil.replaceAll(moveText, "{", " { ");
        StringUtil.replaceAll(moveText, "}", " } ");
        StringUtil.replaceAll(moveText, "(", " ( ");
        StringUtil.replaceAll(moveText, ")", " ) ");
        String text = moveText.toString();
        if (this.getFen() != null && !this.getFen().trim().equals("")) {
            this.setHalfMoves(new MoveList(this.getFen()));
        } else {
            this.setHalfMoves(new MoveList());
        }
        StringBuilder moves = new StringBuilder();
        StringBuilder comment = null;
        LinkedList<RTextEntry> variation = new LinkedList<RTextEntry>();
        int halfMove = 0;
        int variantIndex = 0;
        boolean onCommentBlock = false;
        boolean onVariationBlock = false;
        boolean onLineCommentBlock = false;
        for (String token : text.split(" ")) {
            if (token == null || token.trim().equals("") || !onLineCommentBlock && !onCommentBlock && token.contains("...") && (token = StringUtil.afterSequence(token, "...")).trim().length() == 0 || !onLineCommentBlock && !onCommentBlock && token.contains(".") && (token = StringUtil.afterSequence(token, ".")).trim().length() == 0) continue;
            if (!onLineCommentBlock && !onCommentBlock && token.startsWith("$")) {
                if (this.getNag() == null) {
                    this.setNag(new HashMap<Integer, String>());
                }
                this.getNag().put(variantIndex, token);
                continue;
            }
            if (token.equals("{") && !onLineCommentBlock && !onCommentBlock) {
                onCommentBlock = true;
                comment = new StringBuilder();
                continue;
            }
            if (token.equals("}") && !onLineCommentBlock) {
                onCommentBlock = false;
                if (comment != null) {
                    if (this.getComments() == null) {
                        this.setComments(new HashMap<Integer, String>());
                    }
                    this.getComments().put(variantIndex, comment.toString());
                }
                comment = null;
                continue;
            }
            if (token.equals(";") && !onCommentBlock) {
                onLineCommentBlock = true;
                comment = new StringBuilder();
                continue;
            }
            if (token.equals("\n") && onLineCommentBlock) {
                onLineCommentBlock = false;
                if (comment != null) {
                    this.getComments().put(variantIndex, comment.toString());
                }
                comment = null;
                continue;
            }
            if (token.equals("(") && !onCommentBlock || onLineCommentBlock) {
                onVariationBlock = true;
                variation.add(new RTextEntry(variantIndex));
                continue;
            }
            if (token.equals(")") && onVariationBlock && !onCommentBlock || onLineCommentBlock) {
                onVariationBlock = false;
                if (variation == null) continue;
                RTextEntry last = (RTextEntry)variation.pollLast();
                StringBuilder currentLine = new StringBuilder(Game.getMovesAt(moves.toString(), halfMove));
                try {
                    onVariationBlock = variation.size() > 0;
                    for (RTextEntry entry : variation) {
                        currentLine.append(Game.getMovesAt(entry.text.toString(), entry.size));
                    }
                    MoveList tmp = new MoveList();
                    tmp.loadFromSan(Game.getMovesAt(currentLine.toString(), last.index));
                    MoveList var = MoveList.createMoveListFrom(tmp, tmp.size());
                    var.loadFromSan(last.text.toString());
                    RTextEntry parent = (RTextEntry)variation.peekLast();
                    if (onVariationBlock && parent != null) {
                        var.setParent(parent.index);
                    } else {
                        var.setParent(-1);
                    }
                    if (this.getVariations() == null) {
                        this.setVariations(new HashMap<Integer, MoveList>());
                    }
                    this.getVariations().put(last.index, var);
                    continue;
                }
                catch (Exception e) {
                    if (last != null) {
                        throw new PgnException("Error while reading variation: " + Game.getMovesAt(currentLine.toString(), last.index) + " - " + last.text.toString(), e);
                    }
                    throw new PgnException("Error while reading variation: ", e);
                }
            }
            if (onCommentBlock || onLineCommentBlock) {
                if (comment == null) continue;
                comment.append(token);
                comment.append(" ");
                continue;
            }
            if (onVariationBlock) {
                if (variation == null) continue;
                ((RTextEntry)variation.getLast()).text.append(token);
                ((RTextEntry)variation.getLast()).text.append(" ");
                ++((RTextEntry)variation.getLast()).size;
                ++variantIndex;
                continue;
            }
            ++variantIndex;
            ++halfMove;
            moves.append(token);
            moves.append(" ");
        }
        StringUtil.replaceAll(moves, "\n", " ");
        this.getHalfMoves().loadFromSan(moves.toString());
    }

    public void gotoMove(MoveList moves, int index) throws MoveException {
        this.setCurrentMoveList(moves);
        if (this.getBoard() != null && index >= 0 && index < moves.size()) {
            this.getBoard().loadFromFen(moves.getStartFen());
            int i = 0;
            for (Move move : moves) {
                if (!this.getBoard().doMove(move, true)) {
                    throw new MoveException("Couldn't load board state. Reason: Illegal move in PGN MoveText.");
                }
                if (++i - 1 != index) continue;
                break;
            }
            this.setPosition(i - 1);
        }
    }

    public void gotoFirst(MoveList moves) throws MoveException {
        this.gotoMove(moves, 0);
    }

    public void gotoLast(MoveList moves) throws MoveException {
        this.gotoMove(moves, this.getHalfMoves().size() - 1);
    }

    public void gotoNext(MoveList moves) throws MoveException {
        this.gotoMove(moves, this.getPosition() + 1);
    }

    public void gotoPrior(MoveList moves) throws MoveException {
        this.gotoMove(moves, this.getPosition() - 1);
    }

    public void gotoFirst() throws MoveException {
        this.gotoFirst(this.getCurrentMoveList());
    }

    public void gotoLast() throws MoveException {
        this.gotoLast(this.getCurrentMoveList());
    }

    public void gotoNext() throws MoveException {
        this.gotoNext(this.getCurrentMoveList());
    }

    public void gotoPrior() throws MoveException {
        this.gotoPrior(this.getCurrentMoveList());
    }

    public boolean isEndOfMoveList() {
        return this.getCurrentMoveList() == null || this.getPosition() >= this.getCurrentMoveList().size() - 1;
    }

    public boolean isStartOfMoveList() {
        return this.getCurrentMoveList() == null && this.getPosition() == 0;
    }

    public Map<String, String> getProperty() {
        return this.property;
    }

    public void setProperty(Map<String, String> property) {
        this.property = property;
    }

    class RTextEntry {
        int index;
        int size;
        StringBuilder text = new StringBuilder();

        public RTextEntry(int index) {
            this.index = index;
            this.size = 0;
        }
    }
}

