/*
 * Decompiled with CFR 0.152.
 */
package com.github.bhlangonijr.chesslib;

import com.github.bhlangonijr.chesslib.File;
import com.github.bhlangonijr.chesslib.Rank;
import java.util.EnumMap;

public enum Square {
    A1,
    B1,
    C1,
    D1,
    E1,
    F1,
    G1,
    H1,
    A2,
    B2,
    C2,
    D2,
    E2,
    F2,
    G2,
    H2,
    A3,
    B3,
    C3,
    D3,
    E3,
    F3,
    G3,
    H3,
    A4,
    B4,
    C4,
    D4,
    E4,
    F4,
    G4,
    H4,
    A5,
    B5,
    C5,
    D5,
    E5,
    F5,
    G5,
    H5,
    A6,
    B6,
    C6,
    D6,
    E6,
    F6,
    G6,
    H6,
    A7,
    B7,
    C7,
    D7,
    E7,
    F7,
    G7,
    H7,
    A8,
    B8,
    C8,
    D8,
    E8,
    F8,
    G8,
    H8,
    NONE;

    private static final Square[] allSquares;
    private static final Rank[] rankValues;
    private static final File[] fileValues;
    private static final long[] bitboard;
    private static final EnumMap<Square, Square[]> sideSquare;

    public static Square encode(Rank rank, File file) {
        return allSquares[rank.ordinal() * 8 + file.ordinal()];
    }

    public static Square fromValue(String v) {
        return Square.valueOf(v);
    }

    public static Square squareAt(int index) {
        if (index >= allSquares.length) {
            return NONE;
        }
        return allSquares[index];
    }

    public Square[] getSideSquares() {
        return sideSquare.get((Object)this);
    }

    public Rank getRank() {
        return rankValues[this.ordinal() / 8];
    }

    public File getFile() {
        return fileValues[this.ordinal() % 8];
    }

    public String value() {
        return this.name();
    }

    public long getBitboard() {
        if (this == NONE) {
            return 0L;
        }
        return bitboard[this.ordinal()];
    }

    public boolean isLightSquare() {
        return (this.getBitboard() & 0x55AA55AA55AA55AAL) != 0L;
    }

    static {
        allSquares = Square.values();
        rankValues = Rank.values();
        fileValues = File.values();
        bitboard = new long[allSquares.length];
        sideSquare = new EnumMap(Square.class);
        for (Square sq : allSquares) {
            Square.bitboard[sq.ordinal()] = 1L << sq.ordinal();
            if (NONE.equals((Object)sq)) continue;
            Square[] a = null;
            a = File.FILE_A.equals((Object)sq.getFile()) ? new Square[]{Square.encode(sq.getRank(), File.FILE_B)} : (File.FILE_H.equals((Object)sq.getFile()) ? new Square[]{Square.encode(sq.getRank(), File.FILE_G)} : new Square[]{Square.encode(sq.getRank(), fileValues[sq.getFile().ordinal() - 1]), Square.encode(sq.getRank(), fileValues[sq.getFile().ordinal() + 1])});
            sideSquare.put(sq, a);
        }
    }
}

