/*
 * Decompiled with CFR 0.152.
 */
package com.github.bhlangonijr.chesslib;

import com.github.bhlangonijr.chesslib.PieceType;
import com.github.bhlangonijr.chesslib.Side;
import java.util.HashMap;
import java.util.Map;

public enum Piece {
    WHITE_PAWN(Side.WHITE, PieceType.PAWN, "\u2659", "P"),
    WHITE_KNIGHT(Side.WHITE, PieceType.KNIGHT, "\u2658", "N"),
    WHITE_BISHOP(Side.WHITE, PieceType.BISHOP, "\u2657", "B"),
    WHITE_ROOK(Side.WHITE, PieceType.ROOK, "\u2656", "R"),
    WHITE_QUEEN(Side.WHITE, PieceType.QUEEN, "\u2655", "Q"),
    WHITE_KING(Side.WHITE, PieceType.KING, "\u2654", "K"),
    BLACK_PAWN(Side.BLACK, PieceType.PAWN, "\u265f", "p"),
    BLACK_KNIGHT(Side.BLACK, PieceType.KNIGHT, "\u265e", "n"),
    BLACK_BISHOP(Side.BLACK, PieceType.BISHOP, "\u265d", "b"),
    BLACK_ROOK(Side.BLACK, PieceType.ROOK, "\u265c", "r"),
    BLACK_QUEEN(Side.BLACK, PieceType.QUEEN, "\u265b", "q"),
    BLACK_KING(Side.BLACK, PieceType.KING, "\u265a", "k"),
    NONE(null, null, "NONE", ".");

    private static final Map<String, Piece> fenToPiece;
    public static Piece[] allPieces;
    private static final Piece[][] pieceMake;
    private final Side side;
    private final PieceType type;
    private final String fanSymbol;
    private final String fenSymbol;

    private Piece(Side side, PieceType type, String fanSymbol, String fenSymbol) {
        this.side = side;
        this.type = type;
        this.fanSymbol = fanSymbol;
        this.fenSymbol = fenSymbol;
    }

    public static Piece fromValue(String v) {
        return Piece.valueOf(v);
    }

    public static Piece make(Side side, PieceType type) {
        return pieceMake[type.ordinal()][side.ordinal()];
    }

    public static Piece fromFenSymbol(String fenSymbol) {
        Piece piece = fenToPiece.get(fenSymbol);
        if (piece == null) {
            throw new IllegalArgumentException(String.format("Unknown piece '%s'", fenSymbol));
        }
        return piece;
    }

    public String value() {
        return this.name();
    }

    public PieceType getPieceType() {
        return this.type;
    }

    public Side getPieceSide() {
        return this.side;
    }

    public String getSanSymbol() {
        return this.type.getSanSymbol();
    }

    public String getFanSymbol() {
        return this.fanSymbol;
    }

    public String getFenSymbol() {
        return this.fenSymbol;
    }

    static {
        fenToPiece = new HashMap<String, Piece>(13);
        allPieces = Piece.values();
        pieceMake = new Piece[][]{{WHITE_PAWN, BLACK_PAWN}, {WHITE_KNIGHT, BLACK_KNIGHT}, {WHITE_BISHOP, BLACK_BISHOP}, {WHITE_ROOK, BLACK_ROOK}, {WHITE_QUEEN, BLACK_QUEEN}, {WHITE_KING, BLACK_KING}, {NONE, NONE}};
        for (Piece piece : Piece.values()) {
            fenToPiece.put(piece.getFenSymbol(), piece);
        }
    }
}

