/*
 * Decompiled with CFR 0.152.
 */
package com.github.bhlangonijr.chesslib;

import com.github.bhlangonijr.chesslib.Board;
import com.github.bhlangonijr.chesslib.BoardEvent;
import com.github.bhlangonijr.chesslib.BoardEventType;
import com.github.bhlangonijr.chesslib.CastleRight;
import com.github.bhlangonijr.chesslib.Constants;
import com.github.bhlangonijr.chesslib.Piece;
import com.github.bhlangonijr.chesslib.PieceType;
import com.github.bhlangonijr.chesslib.Side;
import com.github.bhlangonijr.chesslib.Square;
import com.github.bhlangonijr.chesslib.move.Move;
import java.util.EnumMap;

public class MoveBackup
implements BoardEvent {
    private final EnumMap<Side, CastleRight> castleRight = new EnumMap(Side.class);
    private Side sideToMove;
    private Square enPassantTarget;
    private Square enPassant;
    private Integer moveCounter;
    private Integer halfMoveCounter;
    private Move move;
    private Move rookCastleMove;
    private Piece capturedPiece;
    private Square capturedSquare;
    private Piece movingPiece;
    private boolean castleMove;
    private boolean enPassantMove;
    private long incrementalHashKey;

    public MoveBackup() {
    }

    public MoveBackup(Board board, Move move) {
        this();
        this.makeBackup(board, move);
    }

    public void makeBackup(Board board, Move move) {
        this.setIncrementalHashKey(board.getIncrementalHashKey());
        this.setSideToMove(board.getSideToMove());
        this.setEnPassantTarget(board.getEnPassantTarget());
        this.setEnPassant(board.getEnPassant());
        this.setMoveCounter(board.getMoveCounter());
        this.setHalfMoveCounter(board.getHalfMoveCounter());
        this.setMove(move);
        this.getCastleRight().put(Side.WHITE, board.getCastleRight(Side.WHITE));
        this.getCastleRight().put(Side.BLACK, board.getCastleRight(Side.BLACK));
        this.setCapturedPiece(board.getPiece(move.getTo()));
        this.setCapturedSquare(move.getTo());
        Piece moving = board.getPiece(move.getFrom());
        this.setMovingPiece(moving);
        if (board.getContext().isCastleMove(move) && this.movingPiece == Piece.make(board.getSideToMove(), PieceType.KING)) {
            CastleRight c = board.getContext().isKingSideCastle(move) ? CastleRight.KING_SIDE : CastleRight.QUEEN_SIDE;
            Move rookMove = board.getContext().getRookCastleMove(board.getSideToMove(), c);
            this.setRookCastleMove(rookMove);
            this.setCastleMove(true);
        } else {
            this.setRookCastleMove(null);
            this.setCastleMove(false);
        }
    }

    public void restore(Board board) {
        board.setSideToMove(this.getSideToMove());
        board.setEnPassantTarget(this.getEnPassantTarget());
        board.setEnPassant(this.getEnPassant());
        board.setMoveCounter(this.getMoveCounter());
        board.setHalfMoveCounter(this.getHalfMoveCounter());
        Piece movingPiece = this.move.getPromotion() == Piece.NONE ? this.getMovingPiece() : this.move.getPromotion();
        board.getCastleRight().put(Side.WHITE, this.getCastleRight().get((Object)Side.WHITE));
        board.getCastleRight().put(Side.BLACK, this.getCastleRight().get((Object)Side.BLACK));
        if (this.move != Constants.emptyMove) {
            boolean isCastle = board.getContext().isCastleMove(this.getMove());
            if (PieceType.KING.equals((Object)movingPiece.getPieceType()) && isCastle) {
                board.undoMovePiece(this.getRookCastleMove());
            }
            board.unsetPiece(movingPiece, this.getMove().getTo());
            if (Piece.NONE.equals((Object)this.getMove().getPromotion())) {
                board.setPiece(movingPiece, this.getMove().getFrom());
            } else {
                board.setPiece(Piece.make(this.getSideToMove(), PieceType.PAWN), this.getMove().getFrom());
            }
            if (!Piece.NONE.equals((Object)this.getCapturedPiece())) {
                board.setPiece(this.getCapturedPiece(), this.getCapturedSquare());
            }
        }
        board.setIncrementalHashKey(this.getIncrementalHashKey());
    }

    public Side getSideToMove() {
        return this.sideToMove;
    }

    public void setSideToMove(Side sideToMove) {
        this.sideToMove = sideToMove;
    }

    public Square getEnPassantTarget() {
        return this.enPassantTarget;
    }

    public void setEnPassantTarget(Square enPassant) {
        this.enPassantTarget = enPassant;
    }

    public Square getEnPassant() {
        return this.enPassant;
    }

    public void setEnPassant(Square enPassant) {
        this.enPassant = enPassant;
    }

    public Integer getMoveCounter() {
        return this.moveCounter;
    }

    public void setMoveCounter(Integer moveCounter) {
        this.moveCounter = moveCounter;
    }

    public Integer getHalfMoveCounter() {
        return this.halfMoveCounter;
    }

    public void setHalfMoveCounter(Integer halfMoveCounter) {
        this.halfMoveCounter = halfMoveCounter;
    }

    public Move getMove() {
        return this.move;
    }

    public void setMove(Move move) {
        this.move = move;
    }

    public Move getRookCastleMove() {
        return this.rookCastleMove;
    }

    public void setRookCastleMove(Move rookCastleMove) {
        this.rookCastleMove = rookCastleMove;
    }

    public EnumMap<Side, CastleRight> getCastleRight() {
        return this.castleRight;
    }

    public Piece getCapturedPiece() {
        return this.capturedPiece;
    }

    public void setCapturedPiece(Piece capturedPiece) {
        this.capturedPiece = capturedPiece;
    }

    public Square getCapturedSquare() {
        return this.capturedSquare;
    }

    public void setCapturedSquare(Square capturedSquare) {
        this.capturedSquare = capturedSquare;
    }

    @Override
    public BoardEventType getType() {
        return BoardEventType.ON_UNDO_MOVE;
    }

    public Piece getMovingPiece() {
        return this.movingPiece;
    }

    public void setMovingPiece(Piece movingPiece) {
        this.movingPiece = movingPiece;
    }

    public boolean isCastleMove() {
        return this.castleMove;
    }

    public void setCastleMove(boolean castleMove) {
        this.castleMove = castleMove;
    }

    public boolean isEnPassantMove() {
        return this.enPassantMove;
    }

    public void setEnPassantMove(boolean enPassantMove) {
        this.enPassantMove = enPassantMove;
    }

    public long getIncrementalHashKey() {
        return this.incrementalHashKey;
    }

    public void setIncrementalHashKey(long incrementalHashKey) {
        this.incrementalHashKey = incrementalHashKey;
    }
}

