/*
 * Copyright 2017 Ben-Hur Carlos Vieira Langoni Junior
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.github.bhlangonijr.chesslib;

/**
 * The enum Diagonal h 1 a 8.
 */
public enum DiagonalH1A8 {
    /**
     * A 1 a 1 diagonal h 1 a 8.
     */
    A1_A1,
    /**
     * B 1 a 2 diagonal h 1 a 8.
     */
    B1_A2,
    /**
     * C 1 a 3 diagonal h 1 a 8.
     */
    C1_A3,
    /**
     * D 1 a 4 diagonal h 1 a 8.
     */
    D1_A4,
    /**
     * E 1 a 5 diagonal h 1 a 8.
     */
    E1_A5,
    /**
     * F 1 a 6 diagonal h 1 a 8.
     */
    F1_A6,
    /**
     * G 1 a 7 diagonal h 1 a 8.
     */
    G1_A7,
    /**
     * H 1 a 8 diagonal h 1 a 8.
     */
    H1_A8,
    /**
     * B 8 h 2 diagonal h 1 a 8.
     */
    B8_H2,
    /**
     * C 8 h 3 diagonal h 1 a 8.
     */
    C8_H3,
    /**
     * D 8 h 4 diagonal h 1 a 8.
     */
    D8_H4,
    /**
     * E 8 h 5 diagonal h 1 a 8.
     */
    E8_H5,
    /**
     * F 8 h 6 diagonal h 1 a 8.
     */
    F8_H6,
    /**
     * G 8 h 7 diagonal h 1 a 8.
     */
    G8_H7,
    /**
     * H 8 h 8 diagonal h 1 a 8.
     */
    H8_H8
}
