/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.util;

import java.util.Arrays;

public class Storage {
    private long[] values;
    private int count = 0;

    public Storage(int size) {
        this.values = new long[size];
    }

    public int getCount() {
        return this.count;
    }

    public void reset() {
        this.count = 0;
    }

    public void store(long value) {
        if (this.count < this.values.length) {
            this.values[this.count++] = value;
        }
    }

    public long getAverage(boolean limit) {
        return this.computeAverage(this.values, limit);
    }

    public double getDP(boolean limit) {
        return this.computeDP(this.values, limit);
    }

    public long[] getValues() {
        return this.values;
    }

    public long getMax(boolean limit) {
        return this.computeMax(this.values, limit);
    }

    private long computeAverage(long[] values, boolean percent) {
        Arrays.sort(values);
        int limit = 0;
        if (percent) {
            limit = values.length / 10;
        }
        long count = 0L;
        for (int i = limit; i < values.length - limit; ++i) {
            count += values[i];
        }
        return count / (long)(values.length - 2 * limit);
    }

    private long computeMax(long[] values, boolean percent) {
        Arrays.sort(values);
        int limit = 0;
        if (percent) {
            limit = values.length / 10;
        }
        long max = 0L;
        for (int i = limit; i < values.length - limit; ++i) {
            if (values[i] <= max) continue;
            max = values[i];
        }
        return max;
    }

    private double computeDP(long[] values, boolean percent) {
        if (values.length <= 1) {
            return 0.0;
        }
        Arrays.sort(values);
        int limit = 0;
        if (percent) {
            limit = values.length / 10;
        }
        long num = 0L;
        long med = this.computeAverage(values, percent);
        long quad = 0L;
        for (int i = limit; i < values.length - limit; ++i) {
            ++num;
            quad += values[i] * values[i];
        }
        long var = (quad - num * (med * med)) / (num - 1L);
        return Math.sqrt(var);
    }
}

