/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.util;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;

public class SignatureTest {
    public static void main(String[] args) throws Exception {
        byte[] signature;
        int i;
        byte[] data = new byte[20];
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(1024);
        KeyPair kp = kpg.genKeyPair();
        PublicKey publicKey = kp.getPublic();
        PrivateKey privateKey = kp.getPrivate();
        Signature signEng = Signature.getInstance("SHA1withRSA");
        for (i = 0; i < 1000; ++i) {
            signEng = Signature.getInstance("SHA1withRSA");
            signEng.initSign(privateKey);
        }
        long start = System.currentTimeMillis();
        for (i = 0; i < 1000; ++i) {
            signEng = Signature.getInstance("SHA1withRSA");
            signEng.initSign(privateKey);
        }
        long end = System.currentTimeMillis();
        System.out.println("1000 init sign: " + (end - start) + "ms");
        for (i = 0; i < 1000; ++i) {
            signEng.update(data);
            signature = signEng.sign();
        }
        start = System.currentTimeMillis();
        for (i = 0; i < 1000; ++i) {
            signEng.update(data);
            signature = signEng.sign();
        }
        end = System.currentTimeMillis();
        System.out.println("1000 sign: " + (end - start) + "ms");
        signEng.update(data);
        signature = signEng.sign();
        for (i = 0; i < 1000; ++i) {
            signEng = Signature.getInstance("SHA1withRSA");
            signEng.initVerify(publicKey);
        }
        start = System.currentTimeMillis();
        for (i = 0; i < 1000; ++i) {
            signEng = Signature.getInstance("SHA1withRSA");
            signEng.initVerify(publicKey);
        }
        end = System.currentTimeMillis();
        System.out.println("1000 init verify: " + (end - start) + "ms");
        for (i = 0; i < 1000; ++i) {
            signEng.update(data);
            signEng.verify(signature);
        }
        start = System.currentTimeMillis();
        for (i = 0; i < 1000; ++i) {
            signEng.update(data);
            signEng.verify(signature);
        }
        end = System.currentTimeMillis();
        System.out.println("1000 verify: " + (end - start) + "ms");
    }
}

