/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.util;

import bftsmart.consensus.Consensus;
import bftsmart.consensus.Epoch;
import bftsmart.consensus.TimestampValuePair;
import bftsmart.tom.core.TOMLayer;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ShutdownHookThread
extends Thread {
    private final TOMLayer tomLayer;
    private final MessageDigest md;

    public ShutdownHookThread(TOMLayer tomLayer) {
        this.tomLayer = tomLayer;
        this.md = this.tomLayer.md;
    }

    @Override
    public void run() {
        StringBuffer buffer = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
        int lastCons = this.tomLayer.getLastExec();
        int currentCons = this.tomLayer.getInExec();
        Consensus c = null;
        Epoch e = null;
        buffer.append("\n---------- DEBUG INFO ----------\n");
        buffer.append("\nCurrent time: " + sdf.format(new Date()));
        buffer.append("\nCurrent leader: " + this.tomLayer.execManager.getCurrentLeader());
        buffer.append("\nCurrent regency: " + this.tomLayer.getSynchronizer().getLCManager().getLastReg());
        buffer.append("\n\nLast finished consensus: " + (lastCons == -1 ? "None" : Integer.valueOf(lastCons)));
        if (lastCons > -1) {
            c = this.tomLayer.execManager.getConsensus(lastCons);
            for (TimestampValuePair rv : c.getWriteSet()) {
                if (rv.getValue() == null || rv.getValue().length <= 0) continue;
                rv.setHashedValue(this.md.digest(rv.getValue()));
            }
            buffer.append("\n\n\t -- Consensus state: \n\n\t\tETS=" + c.getEts() + " \n\t\tWriteSet=[" + c.getWriteSet() + "] \n\t\t(VAL,TS)=[" + c.getQuorumWrites() + "]");
            e = c.getLastEpoch();
            if (e != null) {
                buffer.append("\n\n\t -- Epoch state: \n" + e.toString());
            }
        }
        buffer.append("\n\nConsensus in execution: " + (currentCons == -1 ? "None" : Integer.valueOf(currentCons)));
        c = null;
        e = null;
        if (currentCons > -1) {
            c = this.tomLayer.execManager.getConsensus(currentCons);
            for (TimestampValuePair rv : c.getWriteSet()) {
                if (rv.getValue() == null || rv.getValue().length <= 0) continue;
                rv.setHashedValue(this.md.digest(rv.getValue()));
            }
            buffer.append("\n\n\t -- Consensus state: \n\n\t\tETS=" + c.getEts() + " \n\t\tWriteSet=[" + c.getWriteSet() + "] \n\t\t(VAL,TS)=[" + c.getQuorumWrites() + "]");
            e = c.getLastEpoch();
            if (e != null) {
                buffer.append("\n\n\t -- Epoch state: \n" + e.toString());
            }
        }
        buffer.append("\n\n---------- ---------- ----------\n");
        System.out.println(buffer);
    }
}

