/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.util;

import bftsmart.reconfiguration.ServerViewController;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.TOMUtil;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Random;

public final class BatchBuilder {
    private Random rnd;

    public BatchBuilder(long seed) {
        this.rnd = new Random(seed);
    }

    private byte[] createBatch(long timestamp, int numberOfNonces, long seed, int numberOfMessages, int totalMessagesSize, boolean useSignatures, byte[][] messages, byte[][] signatures, ServerViewController controller) {
        int size = 20 + (numberOfNonces > 0 ? 8 : 0) + numberOfMessages * (4 + (useSignatures ? TOMUtil.getSignatureSize(controller) : 0)) + totalMessagesSize;
        ByteBuffer proposalBuffer = ByteBuffer.allocate(size);
        proposalBuffer.putLong(timestamp);
        proposalBuffer.putInt(numberOfNonces);
        if (numberOfNonces > 0) {
            proposalBuffer.putLong(seed);
        }
        proposalBuffer.putInt(numberOfMessages);
        for (int i = 0; i < numberOfMessages; ++i) {
            this.putMessage(proposalBuffer, messages[i], false, signatures[i]);
        }
        return proposalBuffer.array();
    }

    private void putMessage(ByteBuffer proposalBuffer, byte[] message, boolean isHash, byte[] signature) {
        proposalBuffer.putInt(isHash ? 0 : message.length);
        proposalBuffer.put(message);
        if (signature != null) {
            proposalBuffer.put(signature);
        }
    }

    public byte[] makeBatch(List<TOMMessage> msgs, int numNounces, long timestamp, ServerViewController controller) {
        int numMsgs = msgs.size();
        int totalMessageSize = 0;
        byte[][] messages = new byte[numMsgs][];
        byte[][] signatures = new byte[numMsgs][];
        int i = 0;
        for (TOMMessage msg : msgs) {
            messages[i] = msg.serializedMessage;
            signatures[i] = msg.serializedMessageSignature;
            totalMessageSize += messages[i].length;
            ++i;
        }
        return this.createBatch(timestamp, numNounces, this.rnd.nextLong(), numMsgs, totalMessageSize, controller.getStaticConf().getUseSignatures() == 1, messages, signatures, controller);
    }

    public byte[] makeBatch(List<TOMMessage> msgs, int numNounces, long seed, long timestamp, ServerViewController controller) {
        int numMsgs = msgs.size();
        int totalMessageSize = 0;
        byte[][] messages = new byte[numMsgs][];
        byte[][] signatures = new byte[numMsgs][];
        int i = 0;
        for (TOMMessage msg : msgs) {
            messages[i] = msg.serializedMessage;
            signatures[i] = msg.serializedMessageSignature;
            totalMessageSize += messages[i].length;
            ++i;
        }
        return this.createBatch(timestamp, numNounces, seed, numMsgs, totalMessageSize, controller.getStaticConf().getUseSignatures() == 1, messages, signatures, controller);
    }
}

