/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices.durability;

import bftsmart.statemanagement.strategy.durability.CSTRequest;
import bftsmart.statemanagement.strategy.durability.CSTRequestF1;
import bftsmart.statemanagement.strategy.durability.CSTState;
import bftsmart.tom.MessageContext;
import bftsmart.tom.server.defaultservices.CommandsInfo;
import bftsmart.tom.server.defaultservices.FileRecoverer;
import bftsmart.tom.server.defaultservices.StateLog;
import bftsmart.tom.util.TOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class DurableStateLog
extends StateLog {
    private int id;
    public static final String DEFAULT_DIR = "files".concat(System.getProperty("file.separator"));
    private static final int INT_BYTE_SIZE = 4;
    private static final int EOF = 0;
    private RandomAccessFile log;
    private boolean syncLog;
    private String logPath;
    private String lastCkpPath;
    private boolean syncCkp;
    private boolean isToLog;
    private ReentrantLock checkpointLock = new ReentrantLock();
    private Map<Integer, Long> logPointers;
    private FileRecoverer fr;

    public DurableStateLog(int id, byte[] initialState, byte[] initialHash, boolean isToLog, boolean syncLog, boolean syncCkp) {
        super(id, initialState, initialHash);
        this.id = id;
        this.isToLog = isToLog;
        this.syncLog = syncLog;
        this.syncCkp = syncCkp;
        this.logPointers = new HashMap<Integer, Long>();
        this.fr = new FileRecoverer(id, DEFAULT_DIR);
    }

    private void createLogFile() {
        this.logPath = DEFAULT_DIR + String.valueOf(this.id) + "." + System.currentTimeMillis() + ".log";
        try {
            this.log = new RandomAccessFile(this.logPath, this.syncLog ? "rwd" : "rw");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addMessageBatch(byte[][] commands, MessageContext[] msgCtx, int consensusId) {
        CommandsInfo command = new CommandsInfo(commands, msgCtx);
        if (this.isToLog) {
            if (this.log == null) {
                this.createLogFile();
            }
            this.writeCommandToDisk(command, consensusId);
        }
    }

    private void writeCommandToDisk(CommandsInfo commandsInfo, int consensusId) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(commandsInfo);
            oos.flush();
            byte[] batchBytes = bos.toByteArray();
            ByteBuffer bf = ByteBuffer.allocate(12 + batchBytes.length);
            bf.putInt(batchBytes.length);
            bf.put(batchBytes);
            bf.putInt(0);
            bf.putInt(consensusId);
            this.log.write(bf.array());
            this.log.seek(this.log.length() - 8L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newCheckpoint(byte[] state, byte[] stateHash, int consensusId) {
        String ckpPath = DEFAULT_DIR + String.valueOf(this.id) + "." + System.currentTimeMillis() + ".tmp";
        try {
            this.checkpointLock.lock();
            RandomAccessFile ckp = new RandomAccessFile(ckpPath, this.syncCkp ? "rwd" : "rw");
            ByteBuffer bf = ByteBuffer.allocate(state.length + stateHash.length + 16);
            bf.putInt(state.length);
            bf.put(state);
            bf.putInt(stateHash.length);
            bf.put(stateHash);
            bf.putInt(0);
            bf.putInt(consensusId);
            byte[] ckpState = bf.array();
            ckp.write(ckpState);
            ckp.close();
            if (this.isToLog) {
                this.deleteLogFile();
            }
            this.deleteLastCkp();
            this.renameCkp(ckpPath);
            if (this.isToLog) {
                this.createLogFile();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.checkpointLock.unlock();
        }
    }

    private void renameCkp(String ckpPath) {
        String finalCkpPath = ckpPath.replace(".tmp", ".ckp");
        new File(ckpPath).renameTo(new File(finalCkpPath));
        this.lastCkpPath = finalCkpPath;
    }

    private void deleteLastCkp() {
        if (this.lastCkpPath != null) {
            new File(this.lastCkpPath).delete();
        }
    }

    private void deleteLogFile() {
        try {
            if (this.log != null) {
                this.log.close();
            }
            new File(this.logPath).delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CSTState getState(CSTRequest cstRequest) {
        int cid = cstRequest.getCID();
        int lastCheckpointCID = this.getLastCheckpointCID();
        int lastCID = this.getLastCID();
        System.out.println("LAST CKP CID = " + lastCheckpointCID);
        System.out.println("CID = " + cid);
        System.out.println("LAST CID = " + lastCID);
        if (cstRequest instanceof CSTRequestF1) {
            CSTRequestF1 requestF1 = (CSTRequestF1)cstRequest;
            if (this.id == requestF1.getCheckpointReplica()) {
                this.checkpointLock.lock();
                byte[] ckpState = this.fr.getCkpState(this.lastCkpPath);
                this.checkpointLock.unlock();
                System.out.println("--- sending checkpoint: " + ckpState.length);
                CommandsInfo[] logLower = this.fr.getLogState(requestF1.getLogLowerSize(), this.logPath);
                CommandsInfo[] logUpper = this.fr.getLogState(this.logPointers.get(requestF1.getLogUpper()), 0, requestF1.getLogUpperSize(), this.logPath);
                byte[] logLowerBytes = TOMUtil.getBytes(logLower);
                System.out.println(logLower.length + " Log lower bytes size: " + logLowerBytes.length);
                byte[] logLowerHash = TOMUtil.computeHash(logLowerBytes);
                byte[] logUpperBytes = TOMUtil.getBytes(logUpper);
                System.out.println(logUpper.length + " Log upper bytes size: " + logUpperBytes.length);
                byte[] logUpperHash = TOMUtil.computeHash(logUpperBytes);
                CSTState cstState = new CSTState(ckpState, null, null, logLowerHash, null, logUpperHash, lastCheckpointCID, lastCID, this.id);
                return cstState;
            }
            if (this.id == requestF1.getLogLower()) {
                System.out.print("--- sending lower log: " + requestF1.getLogLowerSize() + " from " + this.logPointers.get(requestF1.getCheckpointReplica()));
                CommandsInfo[] logLower = this.fr.getLogState(this.logPointers.get(requestF1.getCheckpointReplica()), 0, requestF1.getLogLowerSize(), this.logPath);
                System.out.println(" " + TOMUtil.getBytes(logLower).length + " bytes");
                CSTState cstState = new CSTState(null, null, logLower, null, null, null, lastCheckpointCID, lastCID, this.id);
                return cstState;
            }
            System.out.println("--- sending upper log: " + requestF1.getLogUpperSize());
            this.checkpointLock.lock();
            this.fr.recoverCkpHash(this.lastCkpPath);
            byte[] ckpHash = this.fr.getCkpStateHash();
            byte[] ckpState = this.fr.getCkpState(this.lastCkpPath);
            this.checkpointLock.unlock();
            CommandsInfo[] logUpper = this.fr.getLogState(requestF1.getLogUpperSize(), this.logPath);
            System.out.println(" " + TOMUtil.getBytes(logUpper).length + " bytes");
            System.out.println("--- State size: " + ckpState.length + " Current state Hash: " + ckpHash);
            int lastCIDInState = lastCheckpointCID + requestF1.getLogUpperSize();
            CSTState cstState = new CSTState(null, ckpHash, null, null, logUpper, null, lastCheckpointCID, lastCIDInState, this.id);
            return cstState;
        }
        return null;
    }

    public void transferApplicationState(SocketChannel sChannel, int cid) {
        this.fr.transferCkpState(sChannel, this.lastCkpPath);
    }

    public void setLastCID(int cid, int checkpointPeriod, int checkpointPortion) {
        super.setLastCID(cid);
        if (cid % checkpointPeriod % checkpointPortion == checkpointPortion - 1) {
            int ckpReplicaIndex = (cid % checkpointPeriod + 1) / checkpointPortion - 1;
            try {
                System.out.println(" --- Replica " + ckpReplicaIndex + " took checkpoint. My current log pointer is " + this.log.getFilePointer());
                this.logPointers.put(ckpReplicaIndex, this.log.getFilePointer());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void update(CSTState state) {
        this.newCheckpoint(state.getSerializedState(), state.getStateHash(), state.getCheckpointCID());
        this.setLastCheckpointCID(state.getCheckpointCID());
    }

    protected CSTState loadDurableState() {
        FileRecoverer fr = new FileRecoverer(this.id, DEFAULT_DIR);
        this.lastCkpPath = fr.getLatestFile(".ckp");
        this.logPath = fr.getLatestFile(".log");
        byte[] checkpoint = null;
        if (this.lastCkpPath != null) {
            checkpoint = fr.getCkpState(this.lastCkpPath);
        }
        CommandsInfo[] log = null;
        if (this.logPath != null) {
            log = fr.getLogState(0, this.logPath);
        }
        int ckpLastConsensusId = fr.getCkpLastConsensusId();
        int logLastConsensusId = fr.getLogLastConsensusId();
        CSTState cstState = new CSTState(checkpoint, fr.getCkpStateHash(), log, null, null, null, ckpLastConsensusId, logLastConsensusId, this.id);
        if (logLastConsensusId > ckpLastConsensusId) {
            super.setLastCID(logLastConsensusId);
        } else {
            super.setLastCID(ckpLastConsensusId);
        }
        super.setLastCheckpointCID(ckpLastConsensusId);
        return cstState;
    }
}

