/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices.durability;

import bftsmart.reconfiguration.util.TOMConfiguration;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.StateManager;
import bftsmart.statemanagement.strategy.durability.CSTRequest;
import bftsmart.statemanagement.strategy.durability.CSTState;
import bftsmart.statemanagement.strategy.durability.DurableStateManager;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ReplicaContext;
import bftsmart.tom.server.BatchExecutable;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.defaultservices.CommandsInfo;
import bftsmart.tom.server.defaultservices.durability.DurableStateLog;
import bftsmart.tom.util.Logger;
import bftsmart.tom.util.TOMUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public abstract class DurabilityCoordinator
implements Recoverable,
BatchExecutable {
    private ReentrantLock logLock = new ReentrantLock();
    private ReentrantLock hashLock = new ReentrantLock();
    private ReentrantLock stateLock = new ReentrantLock();
    private TOMConfiguration config;
    private MessageDigest md;
    private DurableStateLog log;
    private StateManager stateManager;
    private int lastCkpCID;
    private int globalCheckpointPeriod;
    private int checkpointPortion;
    private int replicaCkpIndex;

    public DurabilityCoordinator() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            java.util.logging.Logger.getLogger(DurabilityCoordinator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public byte[][] executeBatch(byte[][] commands, MessageContext[] msgCtxs) {
        return this.executeBatch(commands, msgCtxs, false);
    }

    private byte[][] executeBatch(byte[][] commands, MessageContext[] msgCtx, boolean noop) {
        int cid = msgCtx[msgCtx.length - 1].getConsensusId();
        int[] cids = this.consensusIds(msgCtx);
        int checkpointIndex = this.findCheckpointPosition(cids);
        Object replies = new byte[commands.length][];
        if (checkpointIndex == -1) {
            if (!noop) {
                this.stateLock.lock();
                replies = this.appExecuteBatch(commands, msgCtx);
                this.stateLock.unlock();
            }
            Logger.println("(DurabilityCoordinator.executeBatch) Storing message batch in the state log for consensus " + cid);
            this.saveCommands(commands, msgCtx);
        } else {
            byte[][] firstHalf = new byte[checkpointIndex + 1][];
            MessageContext[] firstHalfMsgCtx = new MessageContext[firstHalf.length];
            byte[][] secondHalf = new byte[commands.length - (checkpointIndex + 1)][];
            MessageContext[] secondHalfMsgCtx = new MessageContext[secondHalf.length];
            System.arraycopy(commands, 0, firstHalf, 0, checkpointIndex + 1);
            System.arraycopy(msgCtx, 0, firstHalfMsgCtx, 0, checkpointIndex + 1);
            if (secondHalf.length > 0) {
                System.arraycopy(commands, checkpointIndex + 1, secondHalf, 0, commands.length - (checkpointIndex + 1));
                System.arraycopy(msgCtx, checkpointIndex + 1, secondHalfMsgCtx, 0, commands.length - (checkpointIndex + 1));
            } else {
                firstHalfMsgCtx = msgCtx;
            }
            Object firstHalfReplies = new byte[firstHalf.length][];
            Object secondHalfReplies = new byte[secondHalf.length][];
            cid = msgCtx[checkpointIndex].getConsensusId();
            if (!noop) {
                this.stateLock.lock();
                firstHalfReplies = this.appExecuteBatch(firstHalf, firstHalfMsgCtx);
                this.stateLock.unlock();
            }
            if (cid % this.globalCheckpointPeriod == this.replicaCkpIndex && this.lastCkpCID < cid) {
                Logger.println("(DurabilityCoordinator.executeBatch) Performing checkpoint for consensus " + cid);
                this.stateLock.lock();
                byte[] snapshot = this.getSnapshot();
                this.stateLock.unlock();
                this.saveState(snapshot, cid);
                this.lastCkpCID = cid;
            } else {
                Logger.println("(DurabilityCoordinator.executeBatch) Storing message batch in the state log for consensus " + cid);
                this.saveCommands(firstHalf, firstHalfMsgCtx);
            }
            System.arraycopy(firstHalfReplies, 0, replies, 0, ((byte[][])firstHalfReplies).length);
            if (secondHalf.length > 0) {
                cid = msgCtx[msgCtx.length - 1].getConsensusId();
                if (!noop) {
                    this.stateLock.lock();
                    secondHalfReplies = this.appExecuteBatch(secondHalf, secondHalfMsgCtx);
                    this.stateLock.unlock();
                }
                Logger.println("(DurabilityCoordinator.executeBatch) Storing message batch in the state log for consensus " + cid);
                this.saveCommands(secondHalf, secondHalfMsgCtx);
                System.arraycopy(secondHalfReplies, 0, replies, ((byte[][])firstHalfReplies).length, ((byte[][])secondHalfReplies).length);
            }
        }
        if (cids != null && cids.length > 0) {
            this.getStateManager().setLastCID(cids[cids.length - 1]);
        }
        return replies;
    }

    private int findCheckpointPosition(int[] cids) {
        if (this.config.getGlobalCheckpointPeriod() < 1) {
            return -1;
        }
        if (cids.length == 0) {
            throw new IllegalArgumentException();
        }
        int firstCID = cids[0];
        if ((firstCID + 1) % this.checkpointPortion == 0) {
            return this.cidPosition(cids, firstCID);
        }
        int nextCkpIndex = (firstCID / this.checkpointPortion + 1) * this.checkpointPortion - 1;
        if (nextCkpIndex <= cids[cids.length - 1]) {
            return this.cidPosition(cids, nextCkpIndex);
        }
        return -1;
    }

    private int cidPosition(int[] cids, int cid) {
        int index = -1;
        if (cids[cids.length - 1] == cid) {
            return cids.length - 1;
        }
        for (int i = 0; i < cids.length && cids[i] <= cid; ++i) {
            ++index;
        }
        System.out.println("--- Checkpoint is in position " + index);
        return index;
    }

    @Override
    public ApplicationState getState(int cid, boolean sendState) {
        this.logLock.lock();
        ApplicationState ret = null;
        this.logLock.unlock();
        return ret;
    }

    @Override
    public int setState(ApplicationState recvState) {
        int lastCID = -1;
        if (recvState instanceof CSTState) {
            CSTState state = (CSTState)recvState;
            int lastCheckpointCID = state.getCheckpointCID();
            lastCID = state.getLastCID();
            Logger.println("(DurabilityCoordinator.setState) I'm going to update myself from CID " + lastCheckpointCID + " to CID " + lastCID);
            this.stateLock.lock();
            if (state.getSerializedState() != null) {
                System.out.println("The state is not null. Will install it");
                this.log.update(state);
                this.installSnapshot(state.getSerializedState());
            }
            System.out.print("--- Installing log from " + (lastCheckpointCID + 1) + " to " + lastCID);
            for (int cid = lastCheckpointCID + 1; cid <= lastCID; ++cid) {
                try {
                    Logger.println("(DurabilityCoordinator.setState) interpreting and verifying batched requests for CID " + cid);
                    CommandsInfo cmdInfo = state.getMessageBatch(cid);
                    byte[][] commands = cmdInfo.commands;
                    MessageContext[] msgCtx = cmdInfo.msgCtx;
                    if (commands == null || msgCtx == null || msgCtx[0].isNoOp()) continue;
                    this.appExecuteBatch(commands, msgCtx);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            System.out.println("--- Installed");
            this.stateLock.unlock();
        }
        return lastCID;
    }

    private final byte[] computeHash(byte[] data) {
        byte[] ret = null;
        this.hashLock.lock();
        ret = this.md.digest(data);
        this.hashLock.unlock();
        return ret;
    }

    private void saveState(byte[] snapshot, int lastCID) {
        this.logLock.lock();
        Logger.println("(TOMLayer.saveState) Saving state of CID " + lastCID);
        this.log.newCheckpoint(snapshot, this.computeHash(snapshot), lastCID);
        this.log.setLastCID(-1);
        this.log.setLastCheckpointCID(lastCID);
        this.logLock.unlock();
        Logger.println("(TOMLayer.saveState) Finished saving state of CID " + lastCID);
    }

    private void saveCommands(byte[][] commands, MessageContext[] msgCtx) {
        if (!this.config.isToLog()) {
            return;
        }
        if (commands.length != msgCtx.length) {
            System.out.println("----SIZE OF COMMANDS AND MESSAGE CONTEXTS IS DIFFERENT----");
            System.out.println("----COMMANDS: " + commands.length + ", CONTEXTS: " + msgCtx.length + " ----");
        }
        this.logLock.lock();
        int cid = msgCtx[0].getConsensusId();
        int batchStart = 0;
        for (int i = 0; i <= msgCtx.length; ++i) {
            MessageContext[] batchMsgCtx;
            byte[][] batch;
            if (i == msgCtx.length) {
                batch = (byte[][])Arrays.copyOfRange(commands, batchStart, i);
                batchMsgCtx = Arrays.copyOfRange(msgCtx, batchStart, i);
                this.log.addMessageBatch(batch, batchMsgCtx, cid);
                this.log.setLastCID(cid, this.globalCheckpointPeriod, this.checkpointPortion);
                continue;
            }
            if (msgCtx[i].getConsensusId() <= cid) continue;
            batch = (byte[][])Arrays.copyOfRange(commands, batchStart, i);
            batchMsgCtx = Arrays.copyOfRange(msgCtx, batchStart, i);
            this.log.addMessageBatch(batch, batchMsgCtx, cid);
            this.log.setLastCID(cid, this.globalCheckpointPeriod, this.checkpointPortion);
            cid = msgCtx[i].getConsensusId();
            batchStart = i;
        }
        this.logLock.unlock();
    }

    public CSTState getState(CSTRequest cstRequest) {
        CSTState ret = this.log.getState(cstRequest);
        return ret;
    }

    @Override
    public void setReplicaContext(ReplicaContext replicaContext) {
        this.config = replicaContext.getStaticConfiguration();
        if (this.log == null) {
            this.globalCheckpointPeriod = this.config.getGlobalCheckpointPeriod();
            this.replicaCkpIndex = this.getCheckpointPortionIndex();
            this.checkpointPortion = this.globalCheckpointPeriod / this.config.getN();
            if (this.config.isToLog()) {
                int replicaId = this.config.getProcessId();
                boolean isToLog = this.config.isToLog();
                boolean syncLog = this.config.isToWriteSyncLog();
                boolean syncCkp = this.config.isToWriteSyncCkp();
                this.log = new DurableStateLog(replicaId, null, null, isToLog, syncLog, syncCkp);
                CSTState storedState = this.log.loadDurableState();
                if (storedState.getLastCID() > -1) {
                    System.out.println("LAST CID RECOVERED FROM LOG: " + storedState.getLastCID());
                    this.setState(storedState);
                    this.getStateManager().setLastCID(storedState.getLastCID());
                } else {
                    System.out.println("REPLICA IS IN INITIAL STATE");
                }
            }
            this.getStateManager().askCurrentConsensusId();
        }
    }

    private int getCheckpointPortionIndex() {
        int numberOfReplicas = this.config.getN();
        int ckpIndex = this.globalCheckpointPeriod / numberOfReplicas * (this.config.getProcessId() + 1) - 1;
        return ckpIndex;
    }

    private int[] consensusIds(MessageContext[] ctxs) {
        int[] cids = new int[ctxs.length];
        for (int i = 0; i < ctxs.length; ++i) {
            cids[i] = ctxs[i].getConsensusId();
        }
        return cids;
    }

    @Override
    public StateManager getStateManager() {
        if (this.stateManager == null) {
            this.stateManager = new DurableStateManager();
        }
        return this.stateManager;
    }

    public byte[] getCurrentStateHash() {
        byte[] currentState = this.getSnapshot();
        byte[] currentStateHash = TOMUtil.computeHash(currentState);
        System.out.println("--- State size: " + currentState.length + " Current state Hash: " + Arrays.toString(currentStateHash));
        return currentStateHash;
    }

    @Override
    public byte[] executeUnordered(byte[] command, MessageContext msgCtx) {
        return this.appExecuteUnordered(command, msgCtx);
    }

    @Override
    public void Op(int CID, byte[] requests, MessageContext msgCtx) {
    }

    @Override
    public void noOp(int CID, byte[][] operations, MessageContext[] msgCtxs) {
        this.executeBatch(operations, msgCtxs, true);
    }

    public abstract void installSnapshot(byte[] var1);

    public abstract byte[] getSnapshot();

    public abstract byte[][] appExecuteBatch(byte[][] var1, MessageContext[] var2);

    public abstract byte[] appExecuteUnordered(byte[] var1, MessageContext var2);
}

