/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices;

import bftsmart.tom.MessageContext;
import bftsmart.tom.server.defaultservices.CommandsInfo;
import bftsmart.tom.server.defaultservices.DefaultApplicationState;

public class StateLog {
    private CommandsInfo[] messageBatches;
    private int lastCheckpointCID;
    private byte[] state;
    private byte[] stateHash;
    private int position;
    private int lastCID;
    private int id;

    public StateLog(int id, int k, byte[] initialState, byte[] initialHash) {
        this.messageBatches = new CommandsInfo[k - 1];
        this.lastCheckpointCID = -1;
        this.state = initialState;
        this.stateHash = initialHash;
        this.position = 0;
        this.lastCID = -1;
        this.id = id;
    }

    public StateLog(int id, int k) {
        this.messageBatches = new CommandsInfo[k - 1];
        this.lastCheckpointCID = -1;
        this.state = null;
        this.stateHash = null;
        this.position = 0;
        this.lastCID = -1;
        this.id = id;
    }

    public StateLog(int id, byte[] initialState, byte[] initialHash) {
        this.lastCheckpointCID = -1;
        this.state = initialState;
        this.stateHash = initialHash;
        this.lastCID = -1;
        this.id = id;
    }

    public void newCheckpoint(byte[] state, byte[] stateHash, int lastConsensusId) {
        if (this.messageBatches != null) {
            for (int i = 0; i < this.messageBatches.length; ++i) {
                this.messageBatches[i] = null;
            }
        }
        this.position = 0;
        this.state = state;
        this.stateHash = stateHash;
    }

    public void setLastCheckpointCID(int lastCheckpointCID) {
        this.lastCheckpointCID = lastCheckpointCID;
    }

    public int getLastCheckpointCID() {
        return this.lastCheckpointCID;
    }

    public void setLastCID(int lastCID) {
        this.lastCID = lastCID;
    }

    public int getLastCID() {
        return this.lastCID;
    }

    public byte[] getState() {
        return this.state;
    }

    public byte[] getStateHash() {
        return this.stateHash;
    }

    public void addMessageBatch(byte[][] commands, MessageContext[] msgCtx, int lastConsensusId) {
        if (this.position < this.messageBatches.length) {
            this.messageBatches[this.position] = new CommandsInfo(commands, msgCtx);
            ++this.position;
        }
        this.setLastCID(lastConsensusId);
    }

    public CommandsInfo getMessageBatch(int cid) {
        if (cid > this.lastCheckpointCID && cid <= this.lastCID) {
            return this.messageBatches[cid - this.lastCheckpointCID - 1];
        }
        return null;
    }

    public CommandsInfo[] getMessageBatches() {
        return this.messageBatches;
    }

    public int getNumBatches() {
        return this.position;
    }

    public DefaultApplicationState getApplicationState(int cid, boolean setState) {
        System.out.println("--- CID requested: " + cid + ". Last checkpoint: " + this.lastCheckpointCID + ". Last CID: " + this.lastCID);
        CommandsInfo[] batches = null;
        int lastCID = -1;
        if (cid >= this.lastCheckpointCID && cid <= this.lastCID) {
            System.out.println("--- Constructing ApplicationState up until CID " + cid);
            int size = cid - this.lastCheckpointCID;
            if (size > 0) {
                batches = new CommandsInfo[size];
                for (int i = 0; i < size; ++i) {
                    batches[i] = this.messageBatches[i];
                }
            }
            lastCID = cid;
            return new DefaultApplicationState(batches, this.lastCheckpointCID, lastCID, setState ? this.state : null, this.stateHash, this.id);
        }
        return null;
    }

    public void update(DefaultApplicationState transState) {
        this.position = 0;
        if (transState.getMessageBatches() != null) {
            int i = 0;
            while (i < transState.getMessageBatches().length) {
                this.messageBatches[i] = transState.getMessageBatches()[i];
                this.position = ++i;
            }
        }
        this.lastCheckpointCID = transState.getLastCheckpointCID();
        this.state = transState.getState();
        this.stateHash = transState.getStateHash();
        this.lastCID = transState.getLastCID();
    }
}

