/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices;

import bftsmart.tom.server.defaultservices.CommandsInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;

public class FileRecoverer {
    private byte[] ckpHash;
    private int ckpLastConsensusId;
    private int logLastConsensusId;
    private int replicaId;
    private String defaultDir;

    public FileRecoverer(int replicaId, String defaultDir) {
        this.replicaId = replicaId;
        this.defaultDir = defaultDir;
        this.ckpLastConsensusId = 0;
        this.logLastConsensusId = 0;
    }

    public CommandsInfo[] getLogState(int index, String logPath) {
        RandomAccessFile log = null;
        System.out.println("GETTING LOG FROM " + logPath);
        log = this.openLogFile(logPath);
        if (log != null) {
            CommandsInfo[] logState = this.recoverLogState(log, index);
            try {
                log.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return logState;
        }
        return null;
    }

    public CommandsInfo[] getLogState(long pointer, int startOffset, int number, String logPath) {
        RandomAccessFile log = null;
        System.out.println("GETTING LOG FROM " + logPath);
        log = this.openLogFile(logPath);
        if (log != null) {
            CommandsInfo[] logState = this.recoverLogState(log, pointer, startOffset, number);
            try {
                log.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return logState;
        }
        return null;
    }

    public byte[] getCkpState(String ckpPath) {
        RandomAccessFile ckp = null;
        System.out.println("GETTING CHECKPOINT FROM " + ckpPath);
        ckp = this.openLogFile(ckpPath);
        if (ckp != null) {
            byte[] ckpState = this.recoverCkpState(ckp);
            try {
                ckp.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return ckpState;
        }
        return null;
    }

    public void recoverCkpHash(String ckpPath) {
        RandomAccessFile ckp = null;
        System.out.println("GETTING HASH FROM CHECKPOINT" + ckpPath);
        ckp = this.openLogFile(ckpPath);
        if (ckp != null) {
            byte[] ckpHash = null;
            try {
                int ckpSize = ckp.readInt();
                ckp.skipBytes(ckpSize);
                int hashLength = ckp.readInt();
                ckpHash = new byte[hashLength];
                ckp.read(ckpHash);
                System.out.println("--- Last ckp size: " + ckpSize + " Last ckp hash: " + Arrays.toString(ckpHash));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("State recover was aborted due to an unexpected exception");
            }
            this.ckpHash = ckpHash;
        }
    }

    private byte[] recoverCkpState(RandomAccessFile ckp) {
        byte[] ckpState = null;
        try {
            long ckpLength = ckp.length();
            boolean mayRead = true;
            while (mayRead) {
                try {
                    if (ckp.getFilePointer() < ckpLength) {
                        int size = ckp.readInt();
                        if (size > 0) {
                            ckpState = new byte[size];
                            int read = ckp.read(ckpState);
                            if (read == size) {
                                int hashSize = ckp.readInt();
                                if (hashSize <= 0) continue;
                                this.ckpHash = new byte[hashSize];
                                read = ckp.read(this.ckpHash);
                                if (read == hashSize) {
                                    mayRead = false;
                                    continue;
                                }
                                this.ckpHash = null;
                                ckpState = null;
                                continue;
                            }
                            mayRead = false;
                            ckp = null;
                            continue;
                        }
                        mayRead = false;
                        continue;
                    }
                    mayRead = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ckp = null;
                    mayRead = false;
                }
            }
            if (ckp.readInt() == 0) {
                this.ckpLastConsensusId = ckp.readInt();
                System.out.println("LAST CKP read from file: " + this.ckpLastConsensusId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("State recover was aborted due to an unexpected exception");
        }
        return ckpState;
    }

    public void transferLog(SocketChannel sChannel, int index, String logPath) {
        RandomAccessFile log = null;
        System.out.println("GETTING STATE FROM LOG " + logPath);
        log = this.openLogFile(logPath);
        if (log != null) {
            this.transferLog(log, sChannel, index);
        }
    }

    private void transferLog(RandomAccessFile logFile, SocketChannel sChannel, int index) {
        try {
            long totalBytes = logFile.length();
            System.out.println("---Called transferLog." + totalBytes + " " + (sChannel == null));
            FileChannel fileChannel = logFile.getChannel();
            long bytesTransfered = 0L;
            while (bytesTransfered < totalBytes) {
                long bytesSent;
                long bufferSize = 65536L;
                if (totalBytes - bytesTransfered < bufferSize && (bufferSize = (long)((int)(totalBytes - bytesTransfered))) <= 0L) {
                    bufferSize = (int)totalBytes;
                }
                if ((bytesSent = fileChannel.transferTo(bytesTransfered, bufferSize, sChannel)) <= 0L) continue;
                bytesTransfered += bytesSent;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("State recover was aborted due to an unexpected exception");
        }
    }

    public void transferCkpState(SocketChannel sChannel, String ckpPath) {
        RandomAccessFile ckp = null;
        System.out.println("GETTING CHECKPOINT FROM " + ckpPath);
        ckp = this.openLogFile(ckpPath);
        if (ckp != null) {
            this.transferCkpState(ckp, sChannel);
            try {
                ckp.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void transferCkpState(RandomAccessFile ckp, SocketChannel sChannel) {
        try {
            long milliInit = System.currentTimeMillis();
            System.out.println("--- Sending checkpoint." + ckp.length() + " " + (sChannel == null));
            FileChannel fileChannel = ckp.getChannel();
            long totalBytes = ckp.length();
            long bytesTransfered = 0L;
            while (bytesTransfered < totalBytes) {
                long bytesRead;
                long bufferSize = 65536L;
                if (totalBytes - bytesTransfered < bufferSize && (bufferSize = (long)((int)(totalBytes - bytesTransfered))) <= 0L) {
                    bufferSize = (int)totalBytes;
                }
                if ((bytesRead = fileChannel.transferTo(bytesTransfered, bufferSize, sChannel)) <= 0L) continue;
                bytesTransfered += bytesRead;
            }
            System.out.println("---Took " + (System.currentTimeMillis() - milliInit) + " milliseconds to transfer the checkpoint");
            fileChannel.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("State recover was aborted due to an unexpected exception");
        }
    }

    public byte[] getCkpStateHash() {
        return this.ckpHash;
    }

    public int getCkpLastConsensusId() {
        return this.ckpLastConsensusId;
    }

    public int getLogLastConsensusId() {
        return this.logLastConsensusId;
    }

    private RandomAccessFile openLogFile(String file) {
        try {
            return new RandomAccessFile(file, "r");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private CommandsInfo[] recoverLogState(RandomAccessFile log, int endOffset) {
        try {
            long logLength = log.length();
            ArrayList<CommandsInfo> state = new ArrayList<CommandsInfo>();
            int recoveredBatches = 0;
            boolean mayRead = true;
            System.out.println("filepointer: " + log.getFilePointer() + " loglength " + logLength + " endoffset " + endOffset);
            while (mayRead) {
                try {
                    if (log.getFilePointer() < logLength) {
                        int size = log.readInt();
                        if (size > 0) {
                            byte[] bytes = new byte[size];
                            int read = log.read(bytes);
                            if (read == size) {
                                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                                ObjectInputStream ois = new ObjectInputStream(bis);
                                state.add((CommandsInfo)ois.readObject());
                                if (++recoveredBatches != endOffset) continue;
                                System.out.println("read all " + endOffset + " log messages");
                                return state.toArray(new CommandsInfo[state.size()]);
                            }
                            mayRead = false;
                            System.out.println("STATE CLEAR");
                            state.clear();
                            continue;
                        }
                        this.logLastConsensusId = log.readInt();
                        System.out.print("ELSE 1. Recovered batches: " + recoveredBatches);
                        System.out.println(", logLastConsensusId: " + this.logLastConsensusId);
                        return state.toArray(new CommandsInfo[state.size()]);
                    }
                    System.out.println("ELSE 2 " + recoveredBatches);
                    mayRead = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    state.clear();
                    mayRead = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("State recover was aborted due to an unexpected exception");
        }
        return null;
    }

    private CommandsInfo[] recoverLogState(RandomAccessFile log, long pointer, int startOffset, int number) {
        try {
            byte[] bytes;
            long logLength = log.length();
            ArrayList<CommandsInfo> state = new ArrayList<CommandsInfo>();
            int recoveredBatches = 0;
            boolean mayRead = true;
            log.seek(pointer);
            for (int index = 0; index < startOffset; ++index) {
                int size = log.readInt();
                bytes = new byte[size];
                log.read(bytes);
            }
            while (mayRead) {
                try {
                    if (log.getFilePointer() < logLength) {
                        int size = log.readInt();
                        if (size > 0) {
                            bytes = new byte[size];
                            int read = log.read(bytes);
                            if (read == size) {
                                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                                ObjectInputStream ois = new ObjectInputStream(bis);
                                state.add((CommandsInfo)ois.readObject());
                                if (++recoveredBatches != number) continue;
                                return state.toArray(new CommandsInfo[state.size()]);
                            }
                            System.out.println("recoverLogState (pointer,offset,number) STATE CLEAR");
                            mayRead = false;
                            state.clear();
                            continue;
                        }
                        System.out.println("recoverLogState (pointer,offset,number) ELSE 1");
                        mayRead = false;
                        continue;
                    }
                    System.out.println("recoverLogState (pointer,offset,number) ELSE 2 " + recoveredBatches);
                    mayRead = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    state.clear();
                    mayRead = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("State recover was aborted due to an unexpected exception");
        }
        return null;
    }

    public String getLatestFile(String extention) {
        File directory = new File(this.defaultDir);
        String latestFile = null;
        if (directory.isDirectory()) {
            File[] serverLogs = directory.listFiles(new FileListFilter(this.replicaId, extention));
            long timestamp = 0L;
            for (File f : serverLogs) {
                String[] nameItems = f.getName().split("\\.");
                long filets = new Long(nameItems[1]);
                if (filets <= timestamp) continue;
                timestamp = filets;
                latestFile = f.getAbsolutePath();
            }
        }
        return latestFile;
    }

    private class FileListFilter
    implements FilenameFilter {
        private int id;
        private String extention;

        public FileListFilter(int id, String extention) {
            this.id = id;
            this.extention = extention;
        }

        @Override
        public boolean accept(File directory, String filename) {
            boolean fileOK = false;
            if (this.id >= 0 && filename.startsWith(this.id + ".") && filename.endsWith(this.extention)) {
                fileOK = true;
            }
            return fileOK;
        }
    }
}

