/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices;

import bftsmart.reconfiguration.ServerViewController;
import bftsmart.reconfiguration.util.TOMConfiguration;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.StateManager;
import bftsmart.statemanagement.strategy.StandardStateManager;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ReplicaContext;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.SingleExecutable;
import bftsmart.tom.server.defaultservices.CommandsInfo;
import bftsmart.tom.server.defaultservices.DefaultApplicationState;
import bftsmart.tom.server.defaultservices.DiskStateLog;
import bftsmart.tom.server.defaultservices.StateLog;
import bftsmart.tom.util.Logger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public abstract class DefaultSingleRecoverable
implements Recoverable,
SingleExecutable {
    protected ReplicaContext replicaContext;
    private TOMConfiguration config;
    private ServerViewController controller;
    private int checkpointPeriod;
    private ReentrantLock logLock = new ReentrantLock();
    private ReentrantLock hashLock = new ReentrantLock();
    private ReentrantLock stateLock = new ReentrantLock();
    private MessageDigest md;
    private StateLog log;
    private List<byte[]> commands = new ArrayList<byte[]>();
    private List<MessageContext> msgContexts = new ArrayList<MessageContext>();
    private StateManager stateManager;

    public DefaultSingleRecoverable() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            java.util.logging.Logger.getLogger(DefaultSingleRecoverable.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public byte[] executeOrdered(byte[] command, MessageContext msgCtx) {
        return this.executeOrdered(command, msgCtx, false);
    }

    private byte[] executeOrdered(byte[] command, MessageContext msgCtx, boolean noop) {
        int cid = msgCtx.getConsensusId();
        byte[] reply = null;
        if (!noop) {
            this.stateLock.lock();
            reply = this.appExecuteOrdered(command, msgCtx);
            this.stateLock.unlock();
        }
        this.commands.add(command);
        this.msgContexts.add(msgCtx);
        if (msgCtx.isLastInBatch()) {
            if (cid > 0 && cid % this.checkpointPeriod == 0) {
                Logger.println("(DefaultSingleRecoverable.executeOrdered) Performing checkpoint for consensus " + cid);
                this.stateLock.lock();
                byte[] snapshot = this.getSnapshot();
                this.stateLock.unlock();
                this.saveState(snapshot, cid);
            } else {
                this.saveCommands((byte[][])this.commands.toArray((T[])new byte[0][]), this.msgContexts.toArray(new MessageContext[0]));
            }
            this.getStateManager().setLastCID(cid);
            this.commands = new ArrayList<byte[]>();
            this.msgContexts = new ArrayList<MessageContext>();
        }
        return reply;
    }

    public final byte[] computeHash(byte[] data) {
        byte[] ret = null;
        this.hashLock.lock();
        ret = this.md.digest(data);
        this.hashLock.unlock();
        return ret;
    }

    private StateLog getLog() {
        this.initLog();
        return this.log;
    }

    private void saveState(byte[] snapshot, int lastCID) {
        StateLog thisLog = this.getLog();
        this.logLock.lock();
        Logger.println("(TOMLayer.saveState) Saving state of CID " + lastCID);
        thisLog.newCheckpoint(snapshot, this.computeHash(snapshot), lastCID);
        thisLog.setLastCID(-1);
        thisLog.setLastCheckpointCID(lastCID);
        this.logLock.unlock();
        Logger.println("(TOMLayer.saveState) Finished saving state of CID " + lastCID);
    }

    private void saveCommands(byte[][] commands, MessageContext[] msgCtx) {
        if (commands.length != msgCtx.length) {
            System.out.println("----SIZE OF COMMANDS AND MESSAGE CONTEXTS IS DIFFERENT----");
            System.out.println("----COMMANDS: " + commands.length + ", CONTEXTS: " + msgCtx.length + " ----");
        }
        this.logLock.lock();
        int cid = msgCtx[0].getConsensusId();
        int batchStart = 0;
        for (int i = 0; i <= msgCtx.length; ++i) {
            MessageContext[] batchMsgCtx;
            byte[][] batch;
            if (i == msgCtx.length) {
                batch = (byte[][])Arrays.copyOfRange(commands, batchStart, i);
                batchMsgCtx = Arrays.copyOfRange(msgCtx, batchStart, i);
                this.log.addMessageBatch(batch, batchMsgCtx, cid);
                continue;
            }
            if (msgCtx[i].getConsensusId() <= cid) continue;
            batch = (byte[][])Arrays.copyOfRange(commands, batchStart, i);
            batchMsgCtx = Arrays.copyOfRange(msgCtx, batchStart, i);
            this.log.addMessageBatch(batch, batchMsgCtx, cid);
            cid = msgCtx[i].getConsensusId();
            batchStart = i;
        }
        this.logLock.unlock();
    }

    @Override
    public ApplicationState getState(int cid, boolean sendState) {
        DefaultApplicationState ret;
        this.logLock.lock();
        DefaultApplicationState defaultApplicationState = ret = cid > -1 ? this.getLog().getApplicationState(cid, sendState) : new DefaultApplicationState();
        if (ret == null || this.config.isBFT() && ret.getCertifiedDecision(this.controller) == null) {
            ret = new DefaultApplicationState();
        }
        System.out.println("Getting log until CID " + cid + ", null: " + (ret == null));
        this.logLock.unlock();
        return ret;
    }

    @Override
    public int setState(ApplicationState recvState) {
        int lastCID = -1;
        if (recvState instanceof DefaultApplicationState) {
            DefaultApplicationState state = (DefaultApplicationState)recvState;
            System.out.println("(DefaultSingleRecoverable.setState) last CID in state: " + state.getLastCID());
            this.logLock.lock();
            this.initLog();
            this.log.update(state);
            this.logLock.unlock();
            int lastCheckpointCID = state.getLastCheckpointCID();
            lastCID = state.getLastCID();
            Logger.println("(DefaultSingleRecoverable.setState) I'm going to update myself from CID " + lastCheckpointCID + " to CID " + lastCID);
            this.stateLock.lock();
            this.installSnapshot(state.getState());
            for (int cid = lastCheckpointCID + 1; cid <= lastCID; ++cid) {
                try {
                    Logger.println("(DurabilityCoordinator.setState) interpreting and verifying batched requests for CID " + cid);
                    CommandsInfo cmdInfo = state.getMessageBatch(cid);
                    byte[][] cmds = cmdInfo.commands;
                    MessageContext[] msgCtxs = cmdInfo.msgCtx;
                    if (cmds == null || msgCtxs == null || msgCtxs[0].isNoOp()) continue;
                    for (int i = 0; i < cmds.length; ++i) {
                        this.appExecuteOrdered(cmds[i], msgCtxs[i]);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    if (!(e instanceof ArrayIndexOutOfBoundsException)) continue;
                    System.out.println("CID do ultimo checkpoint: " + state.getLastCheckpointCID());
                    System.out.println("CID do ultimo consenso: " + state.getLastCID());
                    System.out.println("numero de mensagens supostamente no batch: " + (state.getLastCID() - state.getLastCheckpointCID() + 1));
                    System.out.println("numero de mensagens realmente no batch: " + state.getMessageBatches().length);
                }
            }
            this.stateLock.unlock();
        }
        return lastCID;
    }

    @Override
    public void setReplicaContext(ReplicaContext replicaContext) {
        this.replicaContext = replicaContext;
        this.config = replicaContext.getStaticConfiguration();
        this.controller = replicaContext.getSVController();
        if (this.log == null) {
            this.checkpointPeriod = this.config.getCheckpointPeriod();
            byte[] state = this.getSnapshot();
            if (this.config.isToLog() && this.config.logToDisk()) {
                int replicaId = this.config.getProcessId();
                boolean isToLog = this.config.isToLog();
                boolean syncLog = this.config.isToWriteSyncLog();
                boolean syncCkp = this.config.isToWriteSyncCkp();
                this.log = new DiskStateLog(replicaId, state, this.computeHash(state), isToLog, syncLog, syncCkp);
                ApplicationState storedState = ((DiskStateLog)this.log).loadDurableState();
                if (storedState.getLastCID() > 0) {
                    this.setState(storedState);
                    this.getStateManager().setLastCID(storedState.getLastCID());
                }
            } else {
                this.log = new StateLog(this.config.getProcessId(), this.checkpointPeriod, state, this.computeHash(state));
            }
        }
        this.getStateManager().askCurrentConsensusId();
    }

    @Override
    public StateManager getStateManager() {
        if (this.stateManager == null) {
            this.stateManager = new StandardStateManager();
        }
        return this.stateManager;
    }

    private void initLog() {
        if (this.log == null) {
            this.checkpointPeriod = this.config.getCheckpointPeriod();
            byte[] state = this.getSnapshot();
            if (this.config.isToLog() && this.config.logToDisk()) {
                int replicaId = this.config.getProcessId();
                boolean isToLog = this.config.isToLog();
                boolean syncLog = this.config.isToWriteSyncLog();
                boolean syncCkp = this.config.isToWriteSyncCkp();
                this.log = new DiskStateLog(replicaId, state, this.computeHash(state), isToLog, syncLog, syncCkp);
            } else {
                this.log = new StateLog(this.controller.getStaticConf().getProcessId(), this.checkpointPeriod, state, this.computeHash(state));
            }
        }
    }

    @Override
    public byte[] executeUnordered(byte[] command, MessageContext msgCtx) {
        return this.appExecuteUnordered(command, msgCtx);
    }

    @Override
    public void Op(int CID, byte[] requests, MessageContext msgCtx) {
    }

    @Override
    public void noOp(int CID, byte[][] operations, MessageContext[] msgCtx) {
        for (int i = 0; i < msgCtx.length; ++i) {
            this.executeOrdered(operations[i], msgCtx[i], true);
        }
    }

    public abstract void installSnapshot(byte[] var1);

    public abstract byte[] getSnapshot();

    public abstract byte[] appExecuteOrdered(byte[] var1, MessageContext var2);

    public abstract byte[] appExecuteUnordered(byte[] var1, MessageContext var2);
}

