/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices;

import bftsmart.reconfiguration.ServerViewController;
import bftsmart.reconfiguration.util.TOMConfiguration;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.StateManager;
import bftsmart.statemanagement.strategy.StandardStateManager;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ReplicaContext;
import bftsmart.tom.server.BatchExecutable;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.defaultservices.CommandsInfo;
import bftsmart.tom.server.defaultservices.DefaultApplicationState;
import bftsmart.tom.server.defaultservices.DiskStateLog;
import bftsmart.tom.server.defaultservices.StateLog;
import bftsmart.tom.util.Logger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public abstract class DefaultRecoverable
implements Recoverable,
BatchExecutable {
    private int checkpointPeriod;
    private ReentrantLock logLock = new ReentrantLock();
    private ReentrantLock hashLock = new ReentrantLock();
    private ReentrantLock stateLock = new ReentrantLock();
    private TOMConfiguration config;
    private ServerViewController controller;
    private MessageDigest md;
    private StateLog log;
    private StateManager stateManager;

    public DefaultRecoverable() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            java.util.logging.Logger.getLogger(DefaultRecoverable.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public byte[][] executeBatch(byte[][] commands, MessageContext[] msgCtxs) {
        return this.executeBatch(commands, msgCtxs, false);
    }

    private byte[][] executeBatch(byte[][] commands, MessageContext[] msgCtxs, boolean noop) {
        int cid = msgCtxs[msgCtxs.length - 1].getConsensusId();
        int[] cids = this.consensusIds(msgCtxs);
        int checkpointIndex = this.findCheckpointPosition(cids);
        Object replies = new byte[commands.length][];
        if (checkpointIndex == -1) {
            if (!noop) {
                this.stateLock.lock();
                replies = this.appExecuteBatch(commands, msgCtxs);
                this.stateLock.unlock();
            }
            this.saveCommands(commands, msgCtxs);
        } else {
            byte[][] firstHalf = new byte[checkpointIndex + 1][];
            MessageContext[] firstHalfMsgCtx = new MessageContext[firstHalf.length];
            byte[][] secondHalf = new byte[commands.length - (checkpointIndex + 1)][];
            MessageContext[] secondHalfMsgCtx = new MessageContext[secondHalf.length];
            System.arraycopy(commands, 0, firstHalf, 0, checkpointIndex + 1);
            System.arraycopy(msgCtxs, 0, firstHalfMsgCtx, 0, checkpointIndex + 1);
            if (secondHalf.length > 0) {
                System.arraycopy(commands, checkpointIndex + 1, secondHalf, 0, commands.length - (checkpointIndex + 1));
                System.arraycopy(msgCtxs, checkpointIndex + 1, secondHalfMsgCtx, 0, commands.length - (checkpointIndex + 1));
            } else {
                firstHalfMsgCtx = msgCtxs;
            }
            Object firstHalfReplies = new byte[firstHalf.length][];
            Object secondHalfReplies = new byte[secondHalf.length][];
            cid = msgCtxs[checkpointIndex].getConsensusId();
            if (!noop) {
                this.stateLock.lock();
                firstHalfReplies = this.appExecuteBatch(firstHalf, firstHalfMsgCtx);
                this.stateLock.unlock();
            }
            System.out.println("(DefaultRecoverable.executeBatch) Performing checkpoint for consensus " + cid);
            this.stateLock.lock();
            byte[] snapshot = this.getSnapshot();
            this.stateLock.unlock();
            this.saveState(snapshot, cid);
            System.arraycopy(firstHalfReplies, 0, replies, 0, ((byte[][])firstHalfReplies).length);
            if (secondHalf.length > 0) {
                cid = msgCtxs[msgCtxs.length - 1].getConsensusId();
                if (!noop) {
                    this.stateLock.lock();
                    secondHalfReplies = this.appExecuteBatch(secondHalf, secondHalfMsgCtx);
                    this.stateLock.unlock();
                }
                Logger.println("(DefaultRecoverable.executeBatch) Storing message batch in the state log for consensus " + cid);
                this.saveCommands(secondHalf, secondHalfMsgCtx);
                System.arraycopy(secondHalfReplies, 0, replies, ((byte[][])firstHalfReplies).length, ((byte[][])secondHalfReplies).length);
            }
        }
        if (cids != null && cids.length > 0) {
            this.getStateManager().setLastCID(cids[cids.length - 1]);
        }
        return replies;
    }

    public final byte[] computeHash(byte[] data) {
        byte[] ret = null;
        this.hashLock.lock();
        ret = this.md.digest(data);
        this.hashLock.unlock();
        return ret;
    }

    private StateLog getLog() {
        this.initLog();
        return this.log;
    }

    private void saveState(byte[] snapshot, int lastCID) {
        StateLog thisLog = this.getLog();
        this.logLock.lock();
        Logger.println("(TOMLayer.saveState) Saving state of CID " + lastCID);
        thisLog.newCheckpoint(snapshot, this.computeHash(snapshot), lastCID);
        thisLog.setLastCID(lastCID);
        thisLog.setLastCheckpointCID(lastCID);
        this.logLock.unlock();
        Logger.println("(TOMLayer.saveState) Finished saving state of CID " + lastCID);
    }

    private void saveCommands(byte[][] commands, MessageContext[] msgCtx) {
        if (commands.length != msgCtx.length) {
            System.out.println("----SIZE OF COMMANDS AND MESSAGE CONTEXTS IS DIFFERENT----");
            System.out.println("----COMMANDS: " + commands.length + ", CONTEXTS: " + msgCtx.length + " ----");
        }
        this.logLock.lock();
        int cid = msgCtx[0].getConsensusId();
        int batchStart = 0;
        for (int i = 0; i <= msgCtx.length; ++i) {
            MessageContext[] batchMsgCtx;
            byte[][] batch;
            if (i == msgCtx.length) {
                batch = (byte[][])Arrays.copyOfRange(commands, batchStart, i);
                batchMsgCtx = Arrays.copyOfRange(msgCtx, batchStart, i);
                this.log.addMessageBatch(batch, batchMsgCtx, cid);
                continue;
            }
            if (msgCtx[i].getConsensusId() <= cid) continue;
            batch = (byte[][])Arrays.copyOfRange(commands, batchStart, i);
            batchMsgCtx = Arrays.copyOfRange(msgCtx, batchStart, i);
            this.log.addMessageBatch(batch, batchMsgCtx, cid);
            cid = msgCtx[i].getConsensusId();
            batchStart = i;
        }
        this.logLock.unlock();
    }

    @Override
    public ApplicationState getState(int cid, boolean sendState) {
        DefaultApplicationState ret;
        this.logLock.lock();
        DefaultApplicationState defaultApplicationState = ret = cid > -1 ? this.getLog().getApplicationState(cid, sendState) : new DefaultApplicationState();
        if (ret == null || this.config.isBFT() && ret.getCertifiedDecision(this.controller) == null) {
            ret = new DefaultApplicationState();
        }
        this.logLock.unlock();
        return ret;
    }

    @Override
    public int setState(ApplicationState recvState) {
        int lastCID = -1;
        if (recvState instanceof DefaultApplicationState) {
            DefaultApplicationState state = (DefaultApplicationState)recvState;
            int lastCheckpointCID = state.getLastCheckpointCID();
            lastCID = state.getLastCID();
            System.out.println("(DefaultRecoverable.setState) I'm going to update myself from CID " + lastCheckpointCID + " to CID " + lastCID);
            Logger.println("(DefaultRecoverable.setState) I'm going to update myself from CID " + lastCheckpointCID + " to CID " + lastCID);
            this.stateLock.lock();
            if (state.getSerializedState() != null) {
                System.out.println("The state is not null. Will install it");
                this.initLog();
                this.log.update(state);
                this.installSnapshot(state.getSerializedState());
            }
            for (int cid = lastCheckpointCID + 1; cid <= lastCID; ++cid) {
                try {
                    Logger.println("(DefaultRecoverable.setState) interpreting and verifying batched requests for cid " + cid);
                    if (state.getMessageBatch(cid) == null) {
                        System.out.println("(DefaultRecoverable.setState) " + cid + " NULO!!!");
                    }
                    CommandsInfo cmdInfo = state.getMessageBatch(cid);
                    byte[][] commands = cmdInfo.commands;
                    MessageContext[] msgCtx = cmdInfo.msgCtx;
                    if (commands == null || msgCtx == null || msgCtx[0].isNoOp()) continue;
                    this.appExecuteBatch(commands, msgCtx);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    if (!(e instanceof ArrayIndexOutOfBoundsException)) continue;
                    System.out.println("CID do ultimo checkpoint: " + state.getLastCheckpointCID());
                    System.out.println("CID do ultimo consenso: " + state.getLastCID());
                    System.out.println("numero de mensagens supostamente no batch: " + (state.getLastCID() - state.getLastCheckpointCID() + 1));
                    System.out.println("numero de mensagens realmente no batch: " + state.getMessageBatches().length);
                }
            }
            this.stateLock.unlock();
        }
        return lastCID;
    }

    private int[] consensusIds(MessageContext[] ctxs) {
        int[] cids = new int[ctxs.length];
        for (int i = 0; i < ctxs.length; ++i) {
            cids[i] = ctxs[i].getConsensusId();
        }
        return cids;
    }

    private int findCheckpointPosition(int[] cids) {
        if (this.checkpointPeriod < 1) {
            return -1;
        }
        if (cids.length == 0) {
            throw new IllegalArgumentException();
        }
        int firstCID = cids[0];
        if ((firstCID + 1) % this.checkpointPeriod == 0) {
            return this.cidPosition(cids, firstCID);
        }
        int nextCkpIndex = (firstCID / this.checkpointPeriod + 1) * this.checkpointPeriod - 1;
        if (nextCkpIndex <= cids[cids.length - 1]) {
            return this.cidPosition(cids, nextCkpIndex);
        }
        return -1;
    }

    private int cidPosition(int[] cids, int cid) {
        int index = -1;
        if (cids[cids.length - 1] == cid) {
            return cids.length - 1;
        }
        for (int i = 0; i < cids.length && cids[i] <= cid; ++i) {
            ++index;
        }
        System.out.println("--- Checkpoint is in position " + index);
        return index;
    }

    private void initLog() {
        if (this.log == null) {
            this.checkpointPeriod = this.config.getCheckpointPeriod();
            byte[] state = this.getSnapshot();
            if (this.config.isToLog() && this.config.logToDisk()) {
                int replicaId = this.config.getProcessId();
                boolean isToLog = this.config.isToLog();
                boolean syncLog = this.config.isToWriteSyncLog();
                boolean syncCkp = this.config.isToWriteSyncCkp();
                this.log = new DiskStateLog(replicaId, state, this.computeHash(state), isToLog, syncLog, syncCkp);
                ApplicationState storedState = ((DiskStateLog)this.log).loadDurableState();
                if (storedState.getLastCID() > 0) {
                    this.setState(storedState);
                    this.getStateManager().setLastCID(storedState.getLastCID());
                }
            } else {
                this.log = new StateLog(this.config.getProcessId(), this.checkpointPeriod, state, this.computeHash(state));
            }
        }
    }

    @Override
    public void setReplicaContext(ReplicaContext replicaContext) {
        this.config = replicaContext.getStaticConfiguration();
        this.controller = replicaContext.getSVController();
        this.initLog();
        this.getStateManager().askCurrentConsensusId();
    }

    @Override
    public StateManager getStateManager() {
        if (this.stateManager == null) {
            this.stateManager = new StandardStateManager();
        }
        return this.stateManager;
    }

    @Override
    public byte[] executeUnordered(byte[] command, MessageContext msgCtx) {
        return this.appExecuteUnordered(command, msgCtx);
    }

    @Override
    public void Op(int CID, byte[] requests, MessageContext msgCtx) {
    }

    @Override
    public void noOp(int CID, byte[][] operations, MessageContext[] msgCtxs) {
        this.executeBatch(operations, msgCtxs, true);
    }

    public abstract void installSnapshot(byte[] var1);

    public abstract byte[] getSnapshot();

    public abstract byte[][] appExecuteBatch(byte[][] var1, MessageContext[] var2);

    public abstract byte[] appExecuteUnordered(byte[] var1, MessageContext var2);
}

