/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.leaderchange;

import bftsmart.communication.ServerCommunicationSystem;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.leaderchange.LCMessage;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RequestsTimer {
    private Timer timer = new Timer("request timer");
    private RequestTimerTask rtTask = null;
    private TOMLayer tomLayer;
    private long timeout;
    private long shortTimeout;
    private TreeSet<TOMMessage> watched = new TreeSet();
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private boolean enabled = true;
    private ServerCommunicationSystem communication;
    private ServerViewController controller;
    private Hashtable<Integer, Timer> stopTimers = new Hashtable();

    public RequestsTimer(TOMLayer tomLayer, ServerCommunicationSystem communication, ServerViewController controller) {
        this.tomLayer = tomLayer;
        this.communication = communication;
        this.controller = controller;
        this.timeout = this.controller.getStaticConf().getRequestTimeout();
        this.shortTimeout = -1L;
    }

    public void setShortTimeout(long shortTimeout) {
        this.shortTimeout = shortTimeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void startTimer() {
        if (this.rtTask == null) {
            long t = this.shortTimeout > -1L ? this.shortTimeout : this.timeout;
            this.rtTask = new RequestTimerTask();
            if (this.controller.getCurrentViewN() > 1) {
                this.timer.schedule((TimerTask)this.rtTask, t);
            }
        }
    }

    public void stopTimer() {
        if (this.rtTask != null) {
            this.rtTask.cancel();
            this.rtTask = null;
        }
    }

    public void Enabled(boolean phase) {
        this.enabled = phase;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void watch(TOMMessage request) {
        this.rwLock.writeLock().lock();
        this.watched.add(request);
        if (this.watched.size() >= 1 && this.enabled) {
            this.startTimer();
        }
        this.rwLock.writeLock().unlock();
    }

    public void unwatch(TOMMessage request) {
        this.rwLock.writeLock().lock();
        if (this.watched.remove(request) && this.watched.isEmpty()) {
            this.stopTimer();
        }
        this.rwLock.writeLock().unlock();
    }

    public void clearAll() {
        TOMMessage[] requests = new TOMMessage[this.watched.size()];
        this.rwLock.writeLock().lock();
        this.watched.toArray(requests);
        for (TOMMessage request : requests) {
            if (request == null || !this.watched.remove(request) || !this.watched.isEmpty() || this.rtTask == null) continue;
            this.rtTask.cancel();
            this.rtTask = null;
        }
        this.rwLock.writeLock().unlock();
    }

    public void run_lc_protocol() {
        long t = this.shortTimeout > -1L ? this.shortTimeout : this.timeout;
        LinkedList<TOMMessage> pendingRequests = new LinkedList<TOMMessage>();
        this.rwLock.readLock().lock();
        for (TOMMessage request : this.watched) {
            if (request.receptionTime + System.currentTimeMillis() <= t) break;
            pendingRequests.add(request);
        }
        this.rwLock.readLock().unlock();
        if (!pendingRequests.isEmpty()) {
            ListIterator li = pendingRequests.listIterator();
            while (li.hasNext()) {
                TOMMessage request;
                request = (TOMMessage)li.next();
                if (request.timeout) continue;
                request.signed = request.serializedMessageSignature != null;
                this.tomLayer.forwardRequestToLeader(request);
                request.timeout = true;
                li.remove();
            }
            if (!pendingRequests.isEmpty()) {
                System.out.println("Timeout for messages: " + pendingRequests);
                this.tomLayer.getSynchronizer().triggerTimeout(pendingRequests);
            } else {
                this.rtTask = new RequestTimerTask();
                this.timer.schedule((TimerTask)this.rtTask, t);
            }
        } else {
            this.rtTask = null;
            this.timer.purge();
        }
    }

    public void setSTOP(int regency, LCMessage stop) {
        this.stopSTOP(regency);
        SendStopTask stopTask = new SendStopTask(stop);
        Timer stopTimer = new Timer("Stop message");
        stopTimer.schedule((TimerTask)stopTask, this.timeout);
        this.stopTimers.put(regency, stopTimer);
    }

    public void stopAllSTOPs() {
        Iterator<Integer> stops = this.getTimers().iterator();
        while (stops.hasNext()) {
            this.stopSTOP(stops.next());
        }
    }

    public void stopSTOP(int regency) {
        Timer stopTimer = this.stopTimers.remove(regency);
        if (stopTimer != null) {
            stopTimer.cancel();
        }
    }

    public Set<Integer> getTimers() {
        return ((Hashtable)this.stopTimers.clone()).keySet();
    }

    public void shutdown() {
        this.timer.cancel();
        this.stopAllSTOPs();
        Logger.getLogger(RequestsTimer.class.getName()).log(Level.INFO, "RequestsTimer stopped.");
    }

    class SendStopTask
    extends TimerTask {
        private LCMessage stop;

        public SendStopTask(LCMessage stop) {
            this.stop = stop;
        }

        @Override
        public void run() {
            System.out.println("(SendStopTask.run) Re-transmitting STOP message to install regency " + this.stop.getReg());
            RequestsTimer.this.communication.send(RequestsTimer.this.controller.getCurrentViewOtherAcceptors(), this.stop);
            RequestsTimer.this.setSTOP(this.stop.getReg(), this.stop);
        }
    }

    class RequestTimerTask
    extends TimerTask {
        RequestTimerTask() {
        }

        @Override
        public void run() {
            int[] myself = new int[]{RequestsTimer.this.controller.getStaticConf().getProcessId()};
            RequestsTimer.this.communication.send(myself, new LCMessage(-1, 8, -1, null));
        }
    }
}

