/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.core.messages;

import bftsmart.communication.SystemMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.util.DebugInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;

public class TOMMessage
extends SystemMessage
implements Externalizable,
Comparable,
Cloneable {
    private int viewID;
    private TOMMessageType type;
    private int session;
    private int sequence;
    private int operationId;
    private byte[] content = null;
    private transient int id;
    public transient long timestamp = 0L;
    public transient long seed = 0L;
    public transient int numOfNonces = 0;
    public transient int destination = -1;
    public transient boolean signed = false;
    public transient long receptionTime;
    public transient boolean timeout = false;
    public transient boolean recvFromClient = false;
    public transient byte[] serializedMessage = null;
    public transient byte[] serializedMessageSignature = null;
    public transient byte[] serializedMessageMAC = null;
    public transient long consensusStartTime = 0L;
    public transient long proposeReceivedTime = 0L;
    public transient long writeSentTime = 0L;
    public transient long acceptSentTime = 0L;
    public transient long decisionTime = 0L;
    public transient long deliveryTime = 0L;
    public transient long executedTime = 0L;
    public transient TOMMessage reply = null;
    public transient boolean alreadyProposed = false;
    private int replyServer = -1;
    private transient DebugInfo info = null;

    public TOMMessage() {
    }

    public TOMMessage(int sender, int session, int sequence, byte[] content, int view) {
        this(sender, session, sequence, content, view, TOMMessageType.ORDERED_REQUEST);
    }

    public TOMMessage(int sender, int session, int sequence, byte[] content, int view, TOMMessageType type) {
        this(sender, session, sequence, -1, content, view, type);
    }

    public TOMMessage(int sender, int session, int sequence, int operationId, byte[] content, int view, TOMMessageType type) {
        super(sender);
        this.session = session;
        this.sequence = sequence;
        this.operationId = operationId;
        this.viewID = view;
        this.buildId();
        this.content = content;
        this.type = type;
    }

    public DebugInfo getDebugInfo() {
        return this.info;
    }

    public void setDebugInfo(DebugInfo info) {
        this.info = info;
    }

    public int getSession() {
        return this.session;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getOperationId() {
        return this.operationId;
    }

    public int getViewID() {
        return this.viewID;
    }

    public TOMMessageType getReqType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public byte[] getContent() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof TOMMessage)) {
            return false;
        }
        TOMMessage mc = (TOMMessage)o;
        return mc.getSender() == this.sender && mc.getSequence() == this.sequence && mc.getOperationId() == this.operationId;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "(" + this.sender + "," + this.sequence + "," + this.operationId + "," + this.session + ")";
    }

    public void wExternal(DataOutput out) throws IOException {
        out.writeInt(this.sender);
        out.writeInt(this.viewID);
        out.writeInt(this.type.toInt());
        out.writeInt(this.session);
        out.writeInt(this.sequence);
        out.writeInt(this.operationId);
        out.writeInt(this.replyServer);
        if (this.content == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.content.length);
            out.write(this.content);
        }
    }

    public void rExternal(DataInput in) throws IOException, ClassNotFoundException {
        this.sender = in.readInt();
        this.viewID = in.readInt();
        this.type = TOMMessageType.fromInt(in.readInt());
        this.session = in.readInt();
        this.sequence = in.readInt();
        this.operationId = in.readInt();
        this.replyServer = in.readInt();
        int toRead = in.readInt();
        if (toRead != -1) {
            this.content = new byte[toRead];
            in.readFully(this.content);
        }
        this.buildId();
    }

    private void buildId() {
        int hash = 5;
        hash = 59 * hash + this.getSender();
        hash = 59 * hash + this.sequence;
        this.id = hash = 59 * hash + this.session;
    }

    public static int getSenderFromId(int id) {
        return id >>> 20;
    }

    public static byte[] messageToBytes(TOMMessage m) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            m.wExternal(dos);
            dos.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public static TOMMessage bytesToMessage(byte[] b) {
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        DataInputStream dis = new DataInputStream(bais);
        TOMMessage m = new TOMMessage();
        try {
            m.rExternal(dis);
        }
        catch (Exception e) {
            System.out.println("error on bytesToMessage " + e);
            return null;
        }
        return m;
    }

    public int compareTo(Object o) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        TOMMessage tm = (TOMMessage)o;
        if (this.equals(tm)) {
            return 0;
        }
        if (this.getSender() < tm.getSender()) {
            return -1;
        }
        if (this.getSender() > tm.getSender()) {
            return 1;
        }
        if (this.getSession() < tm.getSession()) {
            return -1;
        }
        if (this.getSession() > tm.getSession()) {
            return 1;
        }
        if (this.getSequence() < tm.getSequence()) {
            return -1;
        }
        if (this.getSequence() > tm.getSequence()) {
            return 1;
        }
        if (this.getOperationId() < tm.getOperationId()) {
            return -1;
        }
        if (this.getOperationId() > tm.getOperationId()) {
            return 1;
        }
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int getReplyServer() {
        return this.replyServer;
    }

    public void setReplyServer(int replyServer) {
        this.replyServer = replyServer;
    }
}

