/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.core;

import bftsmart.clientsmanagement.ClientsManager;
import bftsmart.clientsmanagement.RequestList;
import bftsmart.communication.ServerCommunicationSystem;
import bftsmart.communication.client.RequestReceiver;
import bftsmart.consensus.Consensus;
import bftsmart.consensus.Decision;
import bftsmart.consensus.Epoch;
import bftsmart.consensus.roles.Acceptor;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.statemanagement.StateManager;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.core.DeliveryThread;
import bftsmart.tom.core.ExecutionManager;
import bftsmart.tom.core.Synchronizer;
import bftsmart.tom.core.messages.ForwardedMessage;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.leaderchange.RequestsTimer;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.RequestVerifier;
import bftsmart.tom.util.BatchBuilder;
import bftsmart.tom.util.BatchReader;
import bftsmart.tom.util.Logger;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignedObject;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public final class TOMLayer
extends Thread
implements RequestReceiver {
    private boolean doWork = true;
    public ExecutionManager execManager;
    public Acceptor acceptor;
    private ServerCommunicationSystem communication;
    private DeliveryThread dt;
    public StateManager stateManager = null;
    public RequestsTimer requestsTimer;
    public ClientsManager clientsManager;
    private int inExecution = -1;
    private int lastExecuted = -1;
    public MessageDigest md;
    private Signature engine;
    private ReentrantLock hashLock = new ReentrantLock();
    public BatchBuilder bb = new BatchBuilder(System.nanoTime());
    private ReentrantLock leaderLock = new ReentrantLock();
    private Condition iAmLeader = this.leaderLock.newCondition();
    private ReentrantLock messagesLock = new ReentrantLock();
    private Condition haveMessages = this.messagesLock.newCondition();
    private ReentrantLock proposeLock = new ReentrantLock();
    private Condition canPropose = this.proposeLock.newCondition();
    private PrivateKey prk;
    public ServerViewController controller;
    private RequestVerifier verifier;
    private Synchronizer syncher;

    public TOMLayer(ExecutionManager manager, ServiceReplica receiver, Recoverable recoverer, Acceptor a, ServerCommunicationSystem cs, ServerViewController controller, RequestVerifier verifier) {
        super("TOM Layer");
        this.execManager = manager;
        this.acceptor = a;
        this.communication = cs;
        this.controller = controller;
        this.requestsTimer = this.controller.getStaticConf().getRequestTimeout() == 0 ? null : new RequestsTimer(this, this.communication, this.controller);
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        try {
            this.engine = Signature.getInstance("SHA1withRSA");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.prk = this.controller.getStaticConf().getRSAPrivateKey();
        this.dt = new DeliveryThread(this, receiver, recoverer, this.controller);
        this.dt.start();
        this.stateManager = recoverer.getStateManager();
        this.stateManager.init(this, this.dt);
        this.verifier = verifier != null ? verifier : new RequestVerifier(){

            @Override
            public boolean isValidRequest(byte[] request) {
                return true;
            }
        };
        this.clientsManager = new ClientsManager(this.controller, this.requestsTimer, this.verifier);
        this.syncher = new Synchronizer(this);
    }

    public final byte[] computeHash(byte[] data) {
        byte[] ret = null;
        this.hashLock.lock();
        ret = this.md.digest(data);
        this.hashLock.unlock();
        return ret;
    }

    public SignedObject sign(Serializable obj) {
        try {
            return new SignedObject(obj, this.prk, this.engine);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public boolean verifySignature(SignedObject so, int sender) {
        try {
            return so.verify(this.controller.getStaticConf().getRSAPublicKey(sender), this.engine);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public ServerCommunicationSystem getCommunication() {
        return this.communication;
    }

    public void imAmTheLeader() {
        this.leaderLock.lock();
        this.iAmLeader.signal();
        this.leaderLock.unlock();
    }

    public void setLastExec(int last) {
        this.lastExecuted = last;
    }

    public int getLastExec() {
        return this.lastExecuted;
    }

    public void setInExec(int inEx) {
        this.proposeLock.lock();
        Logger.println("(TOMLayer.setInExec) modifying inExec from " + this.inExecution + " to " + inEx);
        this.inExecution = inEx;
        if (inEx == -1 && !this.isRetrievingState()) {
            this.canPropose.signalAll();
        }
        this.proposeLock.unlock();
    }

    public void waitForPaxosToFinish() {
        this.proposeLock.lock();
        this.canPropose.awaitUninterruptibly();
        this.proposeLock.unlock();
    }

    public int getInExec() {
        return this.inExecution;
    }

    @Override
    public void requestReceived(TOMMessage msg) {
        boolean readOnly;
        if (!this.doWork) {
            return;
        }
        boolean bl = readOnly = msg.getReqType() == TOMMessageType.UNORDERED_REQUEST || msg.getReqType() == TOMMessageType.UNORDERED_HASHED_REQUEST;
        if (readOnly) {
            this.dt.deliverUnordered(msg, this.syncher.getLCManager().getLastReg());
        } else if (this.clientsManager.requestReceived(msg, true, this.communication)) {
            this.haveMessages();
        } else {
            Logger.println("(TOMLayer.requestReceived) the received TOMMessage " + msg + " was discarded.");
        }
    }

    public byte[] createPropose(Decision dec) {
        RequestList pendingRequests = this.clientsManager.getPendingRequests();
        int numberOfMessages = pendingRequests.size();
        int numberOfNonces = this.controller.getStaticConf().getNumberOfNonces();
        if (dec.getConsensusId() > -1) {
            dec.firstMessageProposed = (TOMMessage)pendingRequests.getFirst();
            dec.firstMessageProposed.consensusStartTime = System.nanoTime();
        }
        dec.batchSize = numberOfMessages;
        Logger.println("(TOMLayer.run) creating a PROPOSE with " + numberOfMessages + " msgs");
        return this.bb.makeBatch(pendingRequests, numberOfNonces, System.currentTimeMillis(), this.controller);
    }

    @Override
    public void run() {
        Logger.println("Running.");
        while (this.doWork) {
            this.leaderLock.lock();
            Logger.println("Next leader for CID=" + (this.getLastExec() + 1) + ": " + this.execManager.getCurrentLeader());
            if (this.execManager.getCurrentLeader() != this.controller.getStaticConf().getProcessId()) {
                this.iAmLeader.awaitUninterruptibly();
            }
            this.leaderLock.unlock();
            if (!this.doWork) break;
            this.proposeLock.lock();
            if (this.getInExec() != -1) {
                Logger.println("(TOMLayer.run) Waiting for consensus " + this.getInExec() + " termination.");
                this.canPropose.awaitUninterruptibly();
            }
            this.proposeLock.unlock();
            if (!this.doWork) break;
            Logger.println("(TOMLayer.run) I'm the leader.");
            this.messagesLock.lock();
            if (!this.clientsManager.havePendingRequests()) {
                this.haveMessages.awaitUninterruptibly();
            }
            this.messagesLock.unlock();
            if (!this.doWork) break;
            Logger.println("(TOMLayer.run) There are messages to be ordered.");
            Logger.println("(TOMLayer.run) I can try to propose.");
            if (this.execManager.getCurrentLeader() != this.controller.getStaticConf().getProcessId() || !this.clientsManager.havePendingRequests() || this.getInExec() != -1) continue;
            int execId = this.getLastExec() + 1;
            this.setInExec(execId);
            Decision dec = this.execManager.getConsensus(execId).getDecision();
            if (this.controller.getCurrentViewN() == 1) {
                Logger.println("(TOMLayer.run) Only one replica, bypassing consensus.");
                byte[] value = this.createPropose(dec);
                Consensus consensus = this.execManager.getConsensus(dec.getConsensusId());
                Epoch epoch = consensus.getEpoch(0, this.controller);
                epoch.propValue = value;
                epoch.propValueHash = this.computeHash(value);
                epoch.getConsensus().addWritten(value);
                epoch.deserializedPropValue = this.checkProposedValue(value, true);
                epoch.getConsensus().getDecision().firstMessageProposed = epoch.deserializedPropValue[0];
                dec.setDecisionEpoch(epoch);
                this.dt.delivery(dec);
                continue;
            }
            this.execManager.getProposer().startConsensus(execId, this.createPropose(dec));
        }
        java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.INFO, "TOMLayer stopped.");
    }

    public void decided(Decision dec) {
        dec.setRegency(this.syncher.getLCManager().getLastReg());
        dec.setLeader(this.execManager.getCurrentLeader());
        this.dt.delivery(dec);
    }

    public TOMMessage[] checkProposedValue(byte[] proposedValue, boolean addToClientManager) {
        Logger.println("(TOMLayer.isProposedValueValid) starting");
        BatchReader batchReader = new BatchReader(proposedValue, this.controller.getStaticConf().getUseSignatures() == 1);
        TOMMessage[] requests = null;
        try {
            for (TOMMessage r : requests = batchReader.deserialiseRequests(this.controller)) {
                if (!this.controller.getStaticConf().isBFT() || this.verifier.isValidRequest(r.getContent())) continue;
                return null;
            }
            if (addToClientManager) {
                for (int i = 0; i < requests.length; ++i) {
                    if (this.clientsManager.requestReceived(requests[i], false)) continue;
                    this.clientsManager.getClientsLock().unlock();
                    Logger.println("(TOMLayer.isProposedValueValid) finished, return=false");
                    System.out.println("failure in deserialize batch");
                    return null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.clientsManager.getClientsLock().unlock();
            Logger.println("(TOMLayer.isProposedValueValid) finished, return=false");
            return null;
        }
        Logger.println("(TOMLayer.isProposedValueValid) finished, return=true");
        return requests;
    }

    public void forwardRequestToLeader(TOMMessage request) {
        int leaderId = this.execManager.getCurrentLeader();
        if (this.controller.isCurrentViewMember(leaderId)) {
            Logger.println("(TOMLayer.forwardRequestToLeader) forwarding " + request + " to " + leaderId);
            this.communication.send(new int[]{leaderId}, new ForwardedMessage(this.controller.getStaticConf().getProcessId(), request));
        }
    }

    public boolean isRetrievingState() {
        boolean result = this.stateManager != null && this.stateManager.isRetrievingState();
        return result;
    }

    public void setNoExec() {
        Logger.println("(TOMLayer.setNoExec) modifying inExec from " + this.inExecution + " to " + -1);
        this.proposeLock.lock();
        this.inExecution = -1;
        this.canPropose.signalAll();
        this.proposeLock.unlock();
    }

    public void processOutOfContext() {
        int nextConsensus = this.getLastExec() + 1;
        while (this.execManager.receivedOutOfContextPropose(nextConsensus)) {
            this.execManager.processOutOfContextPropose(this.execManager.getConsensus(nextConsensus));
            nextConsensus = this.getLastExec() + 1;
        }
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public Synchronizer getSynchronizer() {
        return this.syncher;
    }

    private void haveMessages() {
        this.messagesLock.lock();
        this.haveMessages.signal();
        this.messagesLock.unlock();
    }

    public DeliveryThread getDeliveryThread() {
        return this.dt;
    }

    public void shutdown() {
        this.doWork = false;
        this.imAmTheLeader();
        this.haveMessages();
        this.setNoExec();
        if (this.requestsTimer != null) {
            this.requestsTimer.shutdown();
        }
        if (this.clientsManager != null) {
            this.clientsManager.clear();
            this.clientsManager.getPendingRequests().clear();
        }
        if (this.dt != null) {
            this.dt.shutdown();
        }
        if (this.communication != null) {
            this.communication.shutdown();
        }
    }
}

