/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.core;

import bftsmart.consensus.Decision;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.leaderchange.CertifiedDecision;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.util.BatchReader;
import bftsmart.tom.util.Logger;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public final class DeliveryThread
extends Thread {
    private boolean doWork = true;
    private final LinkedBlockingQueue<Decision> decided;
    private final TOMLayer tomLayer;
    private final ServiceReplica receiver;
    private final Recoverable recoverer;
    private final ServerViewController controller;
    private final Lock decidedLock = new ReentrantLock();
    private final Condition notEmptyQueue = this.decidedLock.newCondition();
    private ReentrantLock deliverLock = new ReentrantLock();
    private Condition canDeliver = this.deliverLock.newCondition();

    public DeliveryThread(TOMLayer tomLayer, ServiceReplica receiver, Recoverable recoverer, ServerViewController controller) {
        super("Delivery Thread");
        this.decided = new LinkedBlockingQueue();
        this.tomLayer = tomLayer;
        this.receiver = receiver;
        this.recoverer = recoverer;
        this.controller = controller;
    }

    public Recoverable getRecoverer() {
        return this.recoverer;
    }

    public void delivery(Decision dec) {
        if (!this.containsGoodReconfig(dec)) {
            Logger.println("(DeliveryThread.delivery) Decision from consensus " + dec.getConsensusId() + " does not contain good reconfiguration");
            this.tomLayer.setLastExec(dec.getConsensusId());
            this.tomLayer.setInExec(-1);
        }
        try {
            this.decidedLock.lock();
            this.decided.put(dec);
            TOMMessage[] requests = this.extractMessagesFromDecision(dec);
            this.tomLayer.clientsManager.requestsOrdered(requests);
            this.notEmptyQueue.signalAll();
            this.decidedLock.unlock();
            Logger.println("(DeliveryThread.delivery) Consensus " + dec.getConsensusId() + " finished. Decided size=" + this.decided.size());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private boolean containsGoodReconfig(Decision dec) {
        TOMMessage[] decidedMessages;
        for (TOMMessage decidedMessage : decidedMessages = dec.getDeserializedValue()) {
            if (decidedMessage.getReqType() != TOMMessageType.RECONFIG || decidedMessage.getViewID() != this.controller.getCurrentViewId()) continue;
            return true;
        }
        return false;
    }

    public void deliverLock() {
        this.decidedLock.lock();
        this.notEmptyQueue.signalAll();
        this.decidedLock.unlock();
        this.deliverLock.lock();
    }

    public void deliverUnlock() {
        this.deliverLock.unlock();
    }

    public void canDeliver() {
        this.canDeliver.signalAll();
    }

    public void update(ApplicationState state) {
        int lastCID = this.recoverer.setState(state);
        System.out.println("Setting last CID to " + lastCID);
        this.tomLayer.setLastExec(lastCID);
        if (lastCID > 2) {
            int stableConsensus = lastCID - 3;
            this.tomLayer.execManager.removeOutOfContexts(stableConsensus);
        }
        this.tomLayer.setNoExec();
        System.out.print("Current decided size: " + this.decided.size());
        this.decided.clear();
        System.out.println("(DeliveryThread.update) All finished up to " + lastCID);
    }

    @Override
    public void run() {
        while (this.doWork) {
            this.deliverLock();
            while (this.tomLayer.isRetrievingState()) {
                System.out.println("-- Retrieving State");
                this.canDeliver.awaitUninterruptibly();
                if (this.tomLayer.getLastExec() != -1) continue;
                System.out.println("-- Ready to process operations");
            }
            try {
                ArrayList decisions = new ArrayList();
                this.decidedLock.lock();
                if (this.decided.isEmpty()) {
                    this.notEmptyQueue.await();
                }
                this.decided.drainTo(decisions);
                this.decidedLock.unlock();
                if (!this.doWork) break;
                if (decisions.size() > 0) {
                    int cid;
                    TOMMessage[][] requests = new TOMMessage[decisions.size()][];
                    int[] consensusIds = new int[requests.length];
                    int[] leadersIds = new int[requests.length];
                    int[] regenciesIds = new int[requests.length];
                    CertifiedDecision[] cDecs = new CertifiedDecision[requests.length];
                    int count = 0;
                    for (Decision d : decisions) {
                        CertifiedDecision cDec;
                        requests[count] = this.extractMessagesFromDecision(d);
                        consensusIds[count] = d.getConsensusId();
                        leadersIds[count] = d.getLeader();
                        regenciesIds[count] = d.getRegency();
                        cDecs[count] = cDec = new CertifiedDecision(this.controller.getStaticConf().getProcessId(), d.getConsensusId(), d.getValue(), d.getDecisionEpoch().proof);
                        if (requests[count][0].equals(d.firstMessageProposed)) {
                            long time = requests[count][0].timestamp;
                            long seed = requests[count][0].seed;
                            int numOfNonces = requests[count][0].numOfNonces;
                            requests[count][0] = d.firstMessageProposed;
                            requests[count][0].timestamp = time;
                            requests[count][0].seed = seed;
                            requests[count][0].numOfNonces = numOfNonces;
                        }
                        ++count;
                    }
                    Decision lastDecision = (Decision)decisions.get(decisions.size() - 1);
                    if (requests != null && requests.length > 0) {
                        this.deliverMessages(consensusIds, regenciesIds, leadersIds, cDecs, requests);
                        if (this.controller.hasUpdates()) {
                            this.processReconfigMessages(lastDecision.getConsensusId());
                            this.tomLayer.setLastExec(lastDecision.getConsensusId());
                            this.tomLayer.setInExec(-1);
                        }
                    }
                    if ((cid = lastDecision.getConsensusId()) > 2) {
                        int stableConsensus = cid - 3;
                        this.tomLayer.execManager.removeConsensus(stableConsensus);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            this.deliverUnlock();
        }
        java.util.logging.Logger.getLogger(DeliveryThread.class.getName()).log(Level.INFO, "DeliveryThread stopped.");
    }

    private TOMMessage[] extractMessagesFromDecision(Decision dec) {
        TOMMessage[] requests = dec.getDeserializedValue();
        if (requests == null) {
            Logger.println("(DeliveryThread.run) interpreting and verifying batched requests.");
            BatchReader batchReader = new BatchReader(dec.getValue(), this.controller.getStaticConf().getUseSignatures() == 1);
            requests = batchReader.deserialiseRequests(this.controller);
        } else {
            Logger.println("(DeliveryThread.run) using cached requests from the propose.");
        }
        return requests;
    }

    protected void deliverUnordered(TOMMessage request, int regency) {
        Logger.println("(DeliveryThread.deliverUnordered) Received TOMMessage from client " + request.getSender() + " with sequence number " + request.getSequence() + " for session " + request.getSession());
        MessageContext msgCtx = new MessageContext(request.getSender(), request.getViewID(), request.getReqType(), request.getSession(), request.getSequence(), request.getOperationId(), request.getReplyServer(), request.serializedMessageSignature, System.currentTimeMillis(), 0, 0L, regency, -1, -1, null, null, false);
        msgCtx.readOnly = true;
        this.receiver.receiveReadonlyMessage(request, msgCtx);
    }

    private void deliverMessages(int[] consId, int[] regencies, int[] leaders, CertifiedDecision[] cDecs, TOMMessage[][] requests) {
        this.receiver.receiveMessages(consId, regencies, leaders, cDecs, requests);
    }

    private void processReconfigMessages(int consId) {
        byte[] response = this.controller.executeUpdates(consId);
        TOMMessage[] dests = this.controller.clearUpdates();
        if (this.controller.getCurrentView().isMember(this.receiver.getId())) {
            for (int i = 0; i < dests.length; ++i) {
                this.tomLayer.getCommunication().send(new int[]{dests[i].getSender()}, new TOMMessage(this.controller.getStaticConf().getProcessId(), dests[i].getSession(), dests[i].getSequence(), response, this.controller.getCurrentViewId(), TOMMessageType.RECONFIG));
            }
            this.tomLayer.getCommunication().updateServersConnections();
        } else {
            this.receiver.restart();
        }
    }

    public void shutdown() {
        this.doWork = false;
        System.out.println("Shutting down delivery thread");
        this.decidedLock.lock();
        this.notEmptyQueue.signalAll();
        this.decidedLock.unlock();
    }
}

