/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom;

import bftsmart.communication.ServerCommunicationSystem;
import bftsmart.consensus.messages.MessageFactory;
import bftsmart.consensus.roles.Acceptor;
import bftsmart.consensus.roles.Proposer;
import bftsmart.reconfiguration.ReconfigureReply;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.reconfiguration.VMMessage;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ReplicaContext;
import bftsmart.tom.core.ExecutionManager;
import bftsmart.tom.core.ReplyManager;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.leaderchange.CertifiedDecision;
import bftsmart.tom.server.BatchExecutable;
import bftsmart.tom.server.Executable;
import bftsmart.tom.server.FIFOExecutable;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.Replier;
import bftsmart.tom.server.RequestVerifier;
import bftsmart.tom.server.SingleExecutable;
import bftsmart.tom.server.defaultservices.DefaultReplier;
import bftsmart.tom.util.Logger;
import bftsmart.tom.util.ShutdownHookThread;
import bftsmart.tom.util.TOMUtil;
import java.util.ArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class ServiceReplica {
    private int id;
    private ServerCommunicationSystem cs = null;
    private ReplyManager repMan = null;
    private ServerViewController SVController;
    private ReentrantLock waitTTPJoinMsgLock = new ReentrantLock();
    private Condition canProceed = this.waitTTPJoinMsgLock.newCondition();
    private Executable executor = null;
    private Recoverable recoverer = null;
    private TOMLayer tomLayer = null;
    private boolean tomStackCreated = false;
    private ReplicaContext replicaCtx = null;
    private Replier replier = null;
    private RequestVerifier verifier = null;

    public ServiceReplica(int id, Executable executor, Recoverable recoverer) {
        this(id, "", executor, recoverer, null, new DefaultReplier());
    }

    public ServiceReplica(int id, Executable executor, Recoverable recoverer, RequestVerifier verifier) {
        this(id, "", executor, recoverer, verifier, new DefaultReplier());
    }

    public ServiceReplica(int id, Executable executor, Recoverable recoverer, RequestVerifier verifier, Replier replier) {
        this(id, "", executor, recoverer, verifier, replier);
    }

    public ServiceReplica(int id, String configHome, Executable executor, Recoverable recoverer, RequestVerifier verifier, Replier replier) {
        this.id = id;
        this.SVController = new ServerViewController(id, configHome);
        this.executor = executor;
        this.recoverer = recoverer;
        this.replier = replier;
        this.verifier = verifier;
        this.init();
        this.recoverer.setReplicaContext(this.replicaCtx);
        this.replier.setReplicaContext(this.replicaCtx);
    }

    public void setReplyController(Replier replier) {
        this.replier = replier;
    }

    private void init() {
        try {
            this.cs = new ServerCommunicationSystem(this.SVController, this);
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(ServiceReplica.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException("Unable to build a communication system.");
        }
        if (this.SVController.isInCurrentView()) {
            System.out.println("-- In current view: " + this.SVController.getCurrentView());
            this.initTOMLayer();
        } else {
            System.out.println("-- Not in current view: " + this.SVController.getCurrentView());
            System.out.println("-- Waiting for the TTP: " + this.SVController.getCurrentView());
            this.waitTTPJoinMsgLock.lock();
            try {
                this.canProceed.awaitUninterruptibly();
            }
            finally {
                this.waitTTPJoinMsgLock.unlock();
            }
        }
        this.initReplica();
    }

    public void joinMsgReceived(VMMessage msg) {
        ReconfigureReply r = msg.getReply();
        if (r.getView().isMember(this.id)) {
            this.SVController.processJoinResult(r);
            this.initTOMLayer();
            this.cs.updateServersConnections();
            this.cs.joinViewReceived();
            this.waitTTPJoinMsgLock.lock();
            this.canProceed.signalAll();
            this.waitTTPJoinMsgLock.unlock();
        }
    }

    private void initReplica() {
        this.cs.start();
        this.repMan = new ReplyManager(this.SVController.getStaticConf().getNumRepliers(), this.cs);
    }

    public final void receiveReadonlyMessage(TOMMessage message, MessageContext msgCtx) {
        byte[] response = null;
        response = this.executor instanceof FIFOExecutable ? ((FIFOExecutable)this.executor).executeUnorderedFIFO(message.getContent(), msgCtx, message.getSender(), message.getOperationId()) : this.executor.executeUnordered(message.getContent(), msgCtx);
        if (message.getReqType() == TOMMessageType.UNORDERED_HASHED_REQUEST && message.getReplyServer() != this.id) {
            response = TOMUtil.computeHash(response);
        }
        message.reply = new TOMMessage(this.id, message.getSession(), message.getSequence(), response, this.SVController.getCurrentViewId(), message.getReqType());
        if (this.SVController.getStaticConf().getNumRepliers() > 0) {
            this.repMan.send(message);
        } else {
            this.cs.send(new int[]{message.getSender()}, message.reply);
        }
    }

    public void kill() {
        Thread t = new Thread(){

            @Override
            public void run() {
                if (ServiceReplica.this.tomLayer != null) {
                    ServiceReplica.this.tomLayer.shutdown();
                }
            }
        };
        t.start();
    }

    public void restart() {
        Thread t = new Thread(){

            @Override
            public void run() {
                if (ServiceReplica.this.tomLayer != null && ServiceReplica.this.cs != null) {
                    ServiceReplica.this.tomLayer.shutdown();
                    try {
                        ServiceReplica.this.cs.join();
                        ServiceReplica.this.cs.getServersConn().join();
                        ServiceReplica.this.tomLayer.join();
                        ServiceReplica.this.tomLayer.getDeliveryThread().join();
                    }
                    catch (InterruptedException ex) {
                        java.util.logging.Logger.getLogger(ServiceReplica.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    ServiceReplica.this.tomStackCreated = false;
                    ServiceReplica.this.tomLayer = null;
                    ServiceReplica.this.cs = null;
                    ServiceReplica.this.init();
                    ServiceReplica.this.recoverer.setReplicaContext(ServiceReplica.this.replicaCtx);
                    ServiceReplica.this.replier.setReplicaContext(ServiceReplica.this.replicaCtx);
                }
            }
        };
        t.start();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void receiveMessages(int[] consId, int[] regencies, int[] leaders, CertifiedDecision[] cDecs, TOMMessage[][] requests) {
        int numRequests = 0;
        int consensusCount = 0;
        ArrayList<TOMMessage> toBatch = new ArrayList<TOMMessage>();
        ArrayList<MessageContext> msgCtxts = new ArrayList<MessageContext>();
        boolean noop = true;
        for (TOMMessage[] requestsFromConsensus : requests) {
            TOMMessage firstRequest = requestsFromConsensus[0];
            int requestCount = 0;
            noop = true;
            for (TOMMessage request : requestsFromConsensus) {
                if (request.getViewID() == this.SVController.getCurrentViewId()) {
                    if (request.getReqType() == TOMMessageType.ORDERED_REQUEST) {
                        byte[] response;
                        noop = false;
                        ++numRequests;
                        MessageContext msgCtx = new MessageContext(request.getSender(), request.getViewID(), request.getReqType(), request.getSession(), request.getSequence(), request.getOperationId(), request.getReplyServer(), request.serializedMessageSignature, firstRequest.timestamp, request.numOfNonces, request.seed, regencies[consensusCount], leaders[consensusCount], consId[consensusCount], cDecs[consensusCount].getConsMessages(), firstRequest, false);
                        if (requestCount + 1 == requestsFromConsensus.length) {
                            msgCtx.setLastInBatch();
                        }
                        request.deliveryTime = System.nanoTime();
                        if (this.executor instanceof BatchExecutable) {
                            if (this.recoverer != null) {
                                this.recoverer.Op(msgCtx.getConsensusId(), request.getContent(), msgCtx);
                            }
                            msgCtxts.add(msgCtx);
                            toBatch.add(request);
                        } else if (this.executor instanceof FIFOExecutable) {
                            if (this.recoverer != null) {
                                this.recoverer.Op(msgCtx.getConsensusId(), request.getContent(), msgCtx);
                            }
                            response = ((FIFOExecutable)this.executor).executeOrderedFIFO(request.getContent(), msgCtx, request.getSender(), request.getOperationId());
                            request.reply = new TOMMessage(this.id, request.getSession(), request.getSequence(), response, this.SVController.getCurrentViewId());
                            Logger.println("(ServiceReplica.receiveMessages) sending reply to " + request.getSender());
                            this.replier.manageReply(request, msgCtx);
                        } else {
                            if (!(this.executor instanceof SingleExecutable)) throw new UnsupportedOperationException("Interface not existent");
                            if (this.recoverer != null) {
                                this.recoverer.Op(msgCtx.getConsensusId(), request.getContent(), msgCtx);
                            }
                            response = ((SingleExecutable)this.executor).executeOrdered(request.getContent(), msgCtx);
                            request.reply = new TOMMessage(this.id, request.getSession(), request.getSequence(), response, this.SVController.getCurrentViewId());
                            Logger.println("(ServiceReplica.receiveMessages) sending reply to " + request.getSender());
                            this.replier.manageReply(request, msgCtx);
                        }
                    } else {
                        if (request.getReqType() != TOMMessageType.RECONFIG) throw new RuntimeException("Should never reach here!");
                        this.SVController.enqueueUpdate(request);
                    }
                } else if (request.getViewID() < this.SVController.getCurrentViewId()) {
                    this.tomLayer.getCommunication().send(new int[]{request.getSender()}, new TOMMessage(this.SVController.getStaticConf().getProcessId(), request.getSession(), request.getSequence(), TOMUtil.getBytes(this.SVController.getCurrentView()), this.SVController.getCurrentViewId()));
                }
                ++requestCount;
            }
            if (noop && this.recoverer != null) {
                void var17_25;
                System.out.println(" --- A consensus instance finished, but there were no commands to deliver to the application.");
                System.out.println(" --- Notifying recoverable about a blank consensus.");
                byte[][] byArray = null;
                MessageContext[] msgCtx = null;
                if (requestsFromConsensus.length > 0) {
                    byte[][] byArrayArray = new byte[requestsFromConsensus.length][];
                    msgCtx = new MessageContext[requestsFromConsensus.length];
                    int line = 0;
                    for (TOMMessage m : requestsFromConsensus) {
                        byArrayArray[line] = m.getContent();
                        msgCtx[line] = new MessageContext(m.getSender(), m.getViewID(), m.getReqType(), m.getSession(), m.getSequence(), m.getOperationId(), m.getReplyServer(), m.serializedMessageSignature, firstRequest.timestamp, m.numOfNonces, m.seed, regencies[consensusCount], leaders[consensusCount], consId[consensusCount], cDecs[consensusCount].getConsMessages(), firstRequest, true);
                        msgCtx[line].setLastInBatch();
                        ++line;
                    }
                }
                this.recoverer.noOp(consId[consensusCount], (byte[][])var17_25, msgCtx);
            }
            ++consensusCount;
        }
        if (!(this.executor instanceof BatchExecutable) || numRequests <= 0) return;
        byte[][] batch = new byte[numRequests][];
        int line = 0;
        for (TOMMessage m : toBatch) {
            batch[line] = m.getContent();
            ++line;
        }
        MessageContext[] msgContexts = new MessageContext[msgCtxts.size()];
        msgContexts = msgCtxts.toArray(msgContexts);
        byte[][] replies = ((BatchExecutable)this.executor).executeBatch(batch, msgContexts);
        for (int index = 0; index < toBatch.size(); ++index) {
            TOMMessage request = (TOMMessage)toBatch.get(index);
            request.reply = new TOMMessage(this.id, request.getSession(), request.getSequence(), replies[index], this.SVController.getCurrentViewId());
            if (this.SVController.getStaticConf().getNumRepliers() > 0) {
                Logger.println("(ServiceReplica.receiveMessages) sending reply to " + request.getSender() + " with sequence number " + request.getSequence() + " via ReplyManager");
                this.repMan.send(request);
                continue;
            }
            Logger.println("(ServiceReplica.receiveMessages) sending reply to " + request.getSender() + " with sequence number " + request.getSequence());
            this.cs.send(new int[]{request.getSender()}, request.reply);
        }
        Logger.println("BATCHEXECUTOR END");
    }

    private void initTOMLayer() {
        if (this.tomStackCreated) {
            return;
        }
        if (!this.SVController.isInCurrentView()) {
            throw new RuntimeException("I'm not an acceptor!");
        }
        MessageFactory messageFactory = new MessageFactory(this.id);
        Acceptor acceptor = new Acceptor(this.cs, messageFactory, this.SVController);
        this.cs.setAcceptor(acceptor);
        Proposer proposer = new Proposer(this.cs, messageFactory, this.SVController);
        ExecutionManager executionManager = new ExecutionManager(this.SVController, acceptor, proposer, this.id);
        acceptor.setExecutionManager(executionManager);
        this.tomLayer = new TOMLayer(executionManager, this, this.recoverer, acceptor, this.cs, this.SVController, this.verifier);
        executionManager.setTOMLayer(this.tomLayer);
        this.SVController.setTomLayer(this.tomLayer);
        this.cs.setTOMLayer(this.tomLayer);
        this.cs.setRequestReceiver(this.tomLayer);
        acceptor.setTOMLayer(this.tomLayer);
        if (this.SVController.getStaticConf().isShutdownHookEnabled()) {
            Runtime.getRuntime().addShutdownHook(new ShutdownHookThread(this.tomLayer));
        }
        this.tomLayer.start();
        this.tomStackCreated = true;
        this.replicaCtx = new ReplicaContext(this.cs, this.SVController);
    }

    public final ReplicaContext getReplicaContext() {
        return this.replicaCtx;
    }

    public int getId() {
        return this.id;
    }

    class MessageContextPair {
        TOMMessage message;
        MessageContext msgCtx;

        MessageContextPair(TOMMessage message, MessageContext msgCtx) {
            this.message = message;
            this.msgCtx = msgCtx;
        }
    }
}

