/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom;

import bftsmart.reconfiguration.ReconfigureReply;
import bftsmart.reconfiguration.views.View;
import bftsmart.tom.TOMSender;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.util.Extractor;
import bftsmart.tom.util.Logger;
import bftsmart.tom.util.TOMUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class ServiceProxy
extends TOMSender {
    protected ReentrantLock canReceiveLock = new ReentrantLock();
    protected ReentrantLock canSendLock = new ReentrantLock();
    private Semaphore sm = new Semaphore(0);
    private int reqId = -1;
    private int operationId = -1;
    private TOMMessageType requestType;
    private int replyQuorum = 0;
    private TOMMessage[] replies = null;
    private int receivedReplies = 0;
    private TOMMessage response = null;
    private int invokeTimeout = 40;
    private Comparator<byte[]> comparator;
    private Extractor extractor;
    private Random rand = new Random(System.currentTimeMillis());
    private int replyServer;
    private HashResponseController hashResponseController;
    private int invokeUnorderedHashedTimeout = 10;

    public ServiceProxy(int processId) {
        this(processId, null, null, null);
    }

    public ServiceProxy(int processId, String configHome) {
        this(processId, configHome, null, null);
    }

    public ServiceProxy(int processId, String configHome, Comparator<byte[]> replyComparator, Extractor replyExtractor) {
        if (configHome == null) {
            this.init(processId);
        } else {
            this.init(processId, configHome);
        }
        this.replies = new TOMMessage[this.getViewManager().getCurrentViewN()];
        this.comparator = replyComparator != null ? replyComparator : new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                return Arrays.equals(o1, o2) ? 0 : -1;
            }
        };
        this.extractor = replyExtractor != null ? replyExtractor : new Extractor(){

            @Override
            public TOMMessage extractResponse(TOMMessage[] replies, int sameContent, int lastReceived) {
                return replies[lastReceived];
            }
        };
    }

    public int getInvokeTimeout() {
        return this.invokeTimeout;
    }

    public int getInvokeUnorderedHashedTimeout() {
        return this.invokeUnorderedHashedTimeout;
    }

    public void setInvokeTimeout(int invokeTimeout) {
        this.invokeTimeout = invokeTimeout;
    }

    public void setInvokeUnorderedHashedTimeout(int timeout) {
        this.invokeUnorderedHashedTimeout = timeout;
    }

    public byte[] invokeOrdered(byte[] request) {
        return this.invoke(request, TOMMessageType.ORDERED_REQUEST);
    }

    public byte[] invokeUnordered(byte[] request) {
        return this.invoke(request, TOMMessageType.UNORDERED_REQUEST);
    }

    public byte[] invokeUnorderedHashed(byte[] request) {
        return this.invoke(request, TOMMessageType.UNORDERED_HASHED_REQUEST);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] invoke(byte[] request, TOMMessageType reqType) {
        this.canSendLock.lock();
        Arrays.fill(this.replies, null);
        this.receivedReplies = 0;
        this.response = null;
        this.replyQuorum = this.getReplyQuorum();
        this.reqId = this.generateRequestId(reqType);
        this.operationId = this.generateOperationId();
        this.requestType = reqType;
        this.replyServer = -1;
        this.hashResponseController = null;
        if (this.requestType == TOMMessageType.UNORDERED_HASHED_REQUEST) {
            this.replyServer = this.getRandomlyServerId();
            Logger.println("[" + this.getClass().getName() + "] replyServerId(" + this.replyServer + ") " + "pos(" + this.getViewManager().getCurrentViewPos(this.replyServer) + ")");
            this.hashResponseController = new HashResponseController(this.getViewManager().getCurrentViewPos(this.replyServer), this.getViewManager().getCurrentViewProcesses().length);
            TOMMessage sm = new TOMMessage(this.getProcessId(), this.getSession(), this.reqId, this.operationId, request, this.getViewManager().getCurrentViewId(), this.requestType);
            sm.setReplyServer(this.replyServer);
            this.TOMulticast(sm);
        } else {
            this.TOMulticast(request, this.reqId, this.operationId, reqType);
        }
        Logger.println("Sending request (" + (Object)((Object)reqType) + ") with reqId=" + this.reqId);
        Logger.println("Expected number of matching replies: " + this.replyQuorum);
        try {
            if (reqType == TOMMessageType.UNORDERED_HASHED_REQUEST) {
                if (!this.sm.tryAcquire(this.invokeUnorderedHashedTimeout, TimeUnit.SECONDS)) {
                    System.out.println("######## UNORDERED HASHED REQUEST TIMOUT ########");
                    this.canSendLock.unlock();
                    return this.invoke(request, TOMMessageType.ORDERED_REQUEST);
                }
            } else if (!this.sm.tryAcquire(this.invokeTimeout, TimeUnit.SECONDS)) {
                Logger.println("###################TIMEOUT#######################");
                Logger.println("Reply timeout for reqId=" + this.reqId);
                System.out.print(this.getProcessId() + " // " + this.reqId + " // TIMEOUT // ");
                System.out.println("Replies received: " + this.receivedReplies);
                this.canSendLock.unlock();
                return null;
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        Logger.println("Response extracted = " + this.response);
        byte[] ret = null;
        if (this.response == null) {
            Logger.println("Received n-f replies and no response could be extracted.");
            this.canSendLock.unlock();
            if (reqType != TOMMessageType.UNORDERED_REQUEST && reqType != TOMMessageType.UNORDERED_HASHED_REQUEST) {
                throw new RuntimeException("Received n-f replies without f+1 of them matching.");
            }
            Logger.println("###################RETRY#######################");
            return this.invokeOrdered(request);
        }
        if (reqType == TOMMessageType.ORDERED_REQUEST) {
            if (this.response.getViewID() != this.getViewManager().getCurrentViewId()) {
                this.reconfigureTo((View)TOMUtil.getObject(this.response.getContent()));
                this.canSendLock.unlock();
                return this.invoke(request, reqType);
            }
            ret = this.response.getContent();
        } else if (reqType == TOMMessageType.UNORDERED_REQUEST || reqType == TOMMessageType.UNORDERED_HASHED_REQUEST) {
            if (this.response.getViewID() != this.getViewManager().getCurrentViewId()) {
                this.canSendLock.unlock();
                return this.invoke(request, TOMMessageType.ORDERED_REQUEST);
            }
            ret = this.response.getContent();
        } else if (this.response.getViewID() > this.getViewManager().getCurrentViewId()) {
            Logger.println("Reconfiguration request' reply received!");
            Object r = TOMUtil.getObject(this.response.getContent());
            if (r instanceof View) {
                this.reconfigureTo((View)r);
                this.canSendLock.unlock();
                return this.invoke(request, reqType);
            }
            if (r instanceof ReconfigureReply) {
                this.reconfigureTo(((ReconfigureReply)r).getView());
                ret = this.response.getContent();
            } else {
                Logger.println("Unknown response type");
            }
        } else {
            Logger.println("Unexpected execution flow");
        }
        this.canSendLock.unlock();
        return ret;
    }

    private void reconfigureTo(View v) {
        Logger.println("Installing a most up-to-date view with id=" + v.getId());
        this.getViewManager().reconfigureTo(v);
        this.getViewManager().getViewStore().storeView(v);
        this.replies = new TOMMessage[this.getViewManager().getCurrentViewN()];
        this.getCommunicationSystem().updateConnections();
    }

    @Override
    public void replyReceived(TOMMessage reply) {
        Logger.println("Synchronously received reply from " + reply.getSender() + " with sequence number " + reply.getSequence());
        try {
            this.canReceiveLock.lock();
            if (this.reqId == -1) {
                Logger.println("throwing out request: sender=" + reply.getSender() + " reqId=" + reply.getSequence());
                this.canReceiveLock.unlock();
                return;
            }
            int pos = this.getViewManager().getCurrentViewPos(reply.getSender());
            if (pos < 0) {
                this.canReceiveLock.unlock();
                return;
            }
            int sameContent = 1;
            if (reply.getSequence() == this.reqId && reply.getReqType() == this.requestType) {
                Logger.println("Receiving reply from " + reply.getSender() + " with reqId:" + reply.getSequence() + ". Putting on pos=" + pos);
                if (this.requestType == TOMMessageType.UNORDERED_HASHED_REQUEST) {
                    this.response = this.hashResponseController.getResponse(pos, reply);
                    if (this.response != null) {
                        this.reqId = -1;
                        this.sm.release();
                        this.canReceiveLock.unlock();
                        return;
                    }
                } else {
                    if (this.replies[pos] == null) {
                        ++this.receivedReplies;
                    }
                    this.replies[pos] = reply;
                    for (int i = 0; i < this.replies.length; ++i) {
                        if (i == pos && this.getViewManager().getCurrentViewN() != 1 || this.replies[i] == null || this.comparator.compare(this.replies[i].getContent(), reply.getContent()) != 0 || ++sameContent < this.replyQuorum) continue;
                        this.response = this.extractor.extractResponse(this.replies, sameContent, pos);
                        this.reqId = -1;
                        this.sm.release();
                        this.canReceiveLock.unlock();
                        return;
                    }
                }
                if (this.response == null) {
                    if (this.requestType.equals((Object)TOMMessageType.ORDERED_REQUEST)) {
                        if (this.receivedReplies == this.getViewManager().getCurrentViewN()) {
                            this.reqId = -1;
                            this.sm.release();
                        }
                    } else if (this.requestType.equals((Object)TOMMessageType.UNORDERED_HASHED_REQUEST)) {
                        if (this.hashResponseController.getNumberReplies() == this.getViewManager().getCurrentViewN()) {
                            this.reqId = -1;
                            this.sm.release();
                        }
                    } else if (this.receivedReplies != sameContent) {
                        this.reqId = -1;
                        this.sm.release();
                    }
                }
            } else {
                Logger.println("Ignoring reply from " + reply.getSender() + " with reqId:" + reply.getSequence() + ". Currently wait reqId= " + this.reqId);
            }
            this.canReceiveLock.unlock();
        }
        catch (Exception ex) {
            System.out.println("Problem at ServiceProxy.ReplyReceived()");
            ex.printStackTrace();
            this.canReceiveLock.unlock();
        }
    }

    private int getReplyQuorum() {
        if (this.getViewManager().getStaticConf().isBFT()) {
            return (int)Math.ceil((this.getViewManager().getCurrentViewN() + this.getViewManager().getCurrentViewF()) / 2) + 1;
        }
        return (int)Math.ceil(this.getViewManager().getCurrentViewN() / 2) + 1;
    }

    private int getRandomlyServerId() {
        int numServers = super.getViewManager().getCurrentViewProcesses().length;
        int pos = this.rand.nextInt(numServers);
        return super.getViewManager().getCurrentViewProcesses()[pos];
    }

    private class HashResponseController {
        private TOMMessage reply;
        private byte[][] hashReplies;
        private int replyServerPos;
        private int countHashReplies;

        public HashResponseController(int replyServerPos, int length) {
            this.replyServerPos = replyServerPos;
            this.hashReplies = new byte[length][];
            this.reply = null;
            this.countHashReplies = 0;
        }

        public TOMMessage getResponse(int pos, TOMMessage tomMessage) {
            if (this.hashReplies[pos] == null) {
                ++this.countHashReplies;
            }
            if (this.replyServerPos == pos) {
                this.reply = tomMessage;
                this.hashReplies[pos] = TOMUtil.computeHash(tomMessage.getContent());
            } else {
                this.hashReplies[pos] = tomMessage.getContent();
            }
            Logger.println("[" + this.getClass().getName() + "] hashReplies[" + pos + "]=" + Arrays.toString(this.hashReplies[pos]));
            if (this.hashReplies[this.replyServerPos] != null) {
                int sameContent = 1;
                for (int i = 0; i < ServiceProxy.this.replies.length; ++i) {
                    if (i == this.replyServerPos && ServiceProxy.this.getViewManager().getCurrentViewN() != 1 || this.hashReplies[i] == null || !Arrays.equals(this.hashReplies[i], this.hashReplies[this.replyServerPos]) || ++sameContent < ServiceProxy.this.replyQuorum) continue;
                    return this.reply;
                }
            }
            return null;
        }

        public int getNumberReplies() {
            return this.countHashReplies;
        }
    }
}

